/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.altconnections;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.DomainBareJid;

public final class HttpLookupMethod {
    private static final String XRD_NAMESPACE = "http://docs.oasis-open.org/ns/xri/xrd-1.0";

    public static List<URI> lookup(DomainBareJid xmppServiceAddress, String relation) throws IOException, XmlPullParserException, URISyntaxException {
        try (InputStream inputStream = HttpLookupMethod.getXrdStream(xmppServiceAddress);){
            List<URI> endpoints;
            XmlPullParser xmlPullParser = PacketParserUtils.getParserFor(inputStream);
            List<URI> list = endpoints = HttpLookupMethod.parseXrdLinkReferencesFor(xmlPullParser, relation);
            return list;
        }
    }

    public static List<URI> lookup(DomainBareJid xmppServiceAddress, LinkRelation relation) throws IOException, XmlPullParserException, URISyntaxException {
        return HttpLookupMethod.lookup(xmppServiceAddress, relation.attribute);
    }

    public static InputStream getXrdStream(DomainBareJid xmppServiceAddress) throws IOException {
        String metadataUrl = "https://" + xmppServiceAddress + "/.well-known/host-meta";
        URL putUrl = new URL(metadataUrl);
        URLConnection urlConnection = putUrl.openConnection();
        return urlConnection.getInputStream();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<URI> parseXrdLinkReferencesFor(XmlPullParser parser, String relation) throws IOException, XmlPullParserException, URISyntaxException {
        ParserUtils.forwardToStartElement(parser);
        ArrayList<URI> uriList = new ArrayList<URI>();
        int initialDepth = parser.getDepth();
        block4: while (true) {
            XmlPullParser.TagEvent tag = parser.nextTag();
            switch (tag) {
                case START_ELEMENT: {
                    String name = parser.getName();
                    String namespace = parser.getNamespace();
                    String rel = parser.getAttributeValue("rel");
                    if (!namespace.equals(XRD_NAMESPACE) || !name.equals("Link") || !rel.equals(relation)) continue block4;
                    String endpointUri = parser.getAttributeValue("href");
                    URI uri = new URI(endpointUri);
                    uriList.add(uri);
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return uriList;
                }
            }
        }
    }

    public static List<URI> parseXrdLinkReferencesFor(XmlPullParser parser, LinkRelation relation) throws IOException, XmlPullParserException, URISyntaxException {
        return HttpLookupMethod.parseXrdLinkReferencesFor(parser, relation.attribute);
    }

    public static enum LinkRelation {
        BOSH("urn:xmpp:alt-connections:xbosh"),
        WEBSOCKET("urn:xmpp:alt-connections:websocket");

        private final String attribute;

        private LinkRelation(String relAttribute) {
            this.attribute = relAttribute;
        }
    }
}

