/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public abstract class AbstractVector
extends AbstractArray {
    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.VECTOR) {
            return Lisp.T;
        }
        if (type == BuiltInClass.VECTOR) {
            return Lisp.T;
        }
        if (type == Symbol.SEQUENCE) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SEQUENCE) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public final boolean vectorp() {
        return true;
    }

    @Override
    public boolean equalp(LispObject obj) {
        if (obj instanceof AbstractVector) {
            if (this.length() != obj.length()) {
                return false;
            }
            AbstractVector v = (AbstractVector)obj;
            int i = this.length();
            while (i-- > 0) {
                if (this.AREF(i).equalp(v.AREF(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final int getRank() {
        return 1;
    }

    @Override
    public final LispObject getDimensions() {
        return new Cons(Fixnum.getInstance(this.capacity()));
    }

    @Override
    public final int getDimension(int n) {
        if (n != 0) {
            Lisp.error(new TypeError("bad dimension for vector"));
            return 0;
        }
        return this.capacity();
    }

    @Override
    public final int getTotalSize() {
        return this.capacity();
    }

    public abstract int capacity();

    public abstract LispObject subseq(int var1, int var2);

    public LispObject deleteEq(LispObject item) {
        int limit = this.length();
        int i = 0;
        int j = 0;
        while (i < limit) {
            LispObject obj;
            if ((obj = this.AREF(i++)) == item) continue;
            this.aset(j++, obj);
        }
        int newLength = j;
        if (newLength < this.capacity()) {
            this.shrink(newLength);
        }
        return this;
    }

    public LispObject deleteEql(LispObject item) {
        int limit = this.length();
        int i = 0;
        int j = 0;
        while (i < limit) {
            LispObject obj;
            if ((obj = this.AREF(i++)).eql(item)) continue;
            this.aset(j++, obj);
        }
        int newLength = j;
        if (newLength < this.capacity()) {
            this.shrink(newLength);
        }
        return this;
    }

    public abstract void shrink(int var1);

    public int checkIndex(int index) {
        if (index < 0 || index >= this.capacity()) {
            this.badIndex(index, this.capacity());
        }
        return index;
    }

    protected void badIndex(int index, int limit) {
        StringBuilder sb = new StringBuilder("Invalid array index ");
        sb.append(index);
        sb.append(" for ");
        sb.append(this.princToString());
        if (limit > 0) {
            sb.append(" (should be >= 0 and < ");
            sb.append(limit);
            sb.append(").");
        }
        Lisp.error(new TypeError(sb.toString(), Fixnum.getInstance(index), Lisp.list(Symbol.INTEGER, Fixnum.ZERO, Fixnum.getInstance(limit - 1))));
    }

    @Override
    public void setFillPointer(int n) {
        this.noFillPointer();
    }

    @Override
    public void setFillPointer(LispObject obj) {
        this.noFillPointer();
    }

    public boolean isSimpleVector() {
        return false;
    }

    @Override
    public abstract LispObject reverse();

    @Override
    public LispObject nreverse() {
        int i = 0;
        for (int j = this.length() - 1; i < j; ++i, --j) {
            LispObject temp = this.AREF(i);
            this.aset(i, this.AREF(j));
            this.aset(j, temp);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String printObject() {
        LispThread thread = LispThread.currentThread();
        if (Symbol.PRINT_READABLY.symbolValue(thread) != Lisp.NIL) {
            StringBuilder sb = new StringBuilder("#(");
            int limit = this.length();
            for (int i = 0; i < limit; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(this.AREF(i).printObject());
            }
            sb.append(')');
            return sb.toString();
        }
        if (Symbol.PRINT_ARRAY.symbolValue(thread) != Lisp.NIL) {
            LispObject currentPrintLevel;
            int currentLevel;
            int maxLevel = Integer.MAX_VALUE;
            LispObject printLevel = Symbol.PRINT_LEVEL.symbolValue(thread);
            if (printLevel instanceof Fixnum) {
                maxLevel = ((Fixnum)printLevel).value;
            }
            if ((currentLevel = Fixnum.getValue(currentPrintLevel = Lisp._CURRENT_PRINT_LEVEL_.symbolValue(thread))) < maxLevel) {
                StringBuffer sb = new StringBuffer("#(");
                int maxLength = Integer.MAX_VALUE;
                LispObject printLength = Symbol.PRINT_LENGTH.symbolValue(thread);
                if (printLength instanceof Fixnum) {
                    maxLength = ((Fixnum)printLength).value;
                }
                int length = this.length();
                int limit = Math.min(length, maxLength);
                SpecialBindingsMark mark = thread.markSpecialBindings();
                thread.bindSpecial(Lisp._CURRENT_PRINT_LEVEL_, currentPrintLevel.incr());
                try {
                    for (int i = 0; i < limit; ++i) {
                        if (i > 0) {
                            sb.append(' ');
                        }
                        sb.append(this.AREF(i).printObject());
                    }
                }
                finally {
                    thread.resetSpecialBindings(mark);
                }
                if (limit < length) {
                    sb.append(limit > 0 ? " ..." : "...");
                }
                sb.append(')');
                return sb.toString();
            }
            return "#";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.isSimpleVector() ? "SIMPLE-VECTOR " : "VECTOR ");
        sb.append(this.capacity());
        return this.unreadableString(sb.toString());
    }

    @Override
    public int psxhash() {
        int length = this.length();
        int limit = length < 4 ? length : 4;
        long result = 48920713L;
        for (int i = 0; i < limit; ++i) {
            result = Lisp.mix(result, this.AREF(i).psxhash());
        }
        return (int)(result & Integer.MAX_VALUE);
    }

    public abstract AbstractArray adjustArray(int var1, LispObject var2, LispObject var3);

    public abstract AbstractArray adjustArray(int var1, AbstractArray var2, int var3);

    @Override
    public AbstractArray adjustArray(int[] dims, LispObject initialElement, LispObject initialContents) {
        return this.adjustArray(dims[0], initialElement, initialContents);
    }

    @Override
    public AbstractArray adjustArray(int[] dims, AbstractArray displacedTo, int displacement) {
        return this.adjustArray(dims[0], displacedTo, displacement);
    }
}

