/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleError;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SlotClass;
import org.armedbear.lisp.Symbol;

public class StructureClass
extends SlotClass {
    private static final Primitive MAKE_STRUCTURE_CLASS = new Primitive("make-structure-class", Lisp.PACKAGE_SYS, false){

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            Symbol symbol = Lisp.checkSymbol(first);
            LispClass existingClass = LispClass.findClass(symbol);
            if (existingClass instanceof StructureClass) {
                return existingClass;
            }
            LispObject directSlots = Lisp.checkList(second);
            LispObject slots = Lisp.checkList(third);
            Symbol include = Lisp.checkSymbol(fourth);
            StructureClass c = new StructureClass(symbol);
            if (include != Lisp.NIL) {
                LispClass includedClass = LispClass.findClass(include);
                if (includedClass == null) {
                    return Lisp.error(new SimpleError("Class " + String.valueOf(include) + " is undefined."));
                }
                c.setCPL(new Cons(c, includedClass.getCPL()));
            } else {
                c.setCPL(c, BuiltInClass.STRUCTURE_OBJECT, BuiltInClass.CLASS_T);
            }
            c.setDirectSlotDefinitions(directSlots);
            c.setSlotDefinitions(slots);
            c.setFinalized(true);
            LispClass.addClass(symbol, c);
            return c;
        }
    };

    StructureClass(Symbol symbol) {
        super(symbol, new Cons(BuiltInClass.STRUCTURE_OBJECT));
    }

    public StructureClass(Symbol symbol, LispObject directSuperclasses) {
        super(symbol, directSuperclasses);
    }

    @Override
    public LispObject typeOf() {
        return Symbol.STRUCTURE_CLASS;
    }

    @Override
    public LispObject classOf() {
        return LispClass.findClass(Symbol.STRUCTURE_CLASS);
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.STRUCTURE_CLASS) {
            return Lisp.T;
        }
        if (type == LispClass.findClass(Symbol.STRUCTURE_CLASS)) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public LispObject getDescription() {
        return new SimpleString(this.princToString());
    }

    @Override
    public String printObject() {
        StringBuilder sb = new StringBuilder("STRUCTURE-CLASS ");
        sb.append(this.getName().princToString());
        return this.unreadableString(sb.toString(), false);
    }
}

