/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.JarPathname;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.URLPathname;

public final class probe_file {
    public static final Primitive PROBE_FILE = new pf_probe_file();
    public static final Primitive TRUENAME = new pf_truename();
    public static final Primitive PROBE_DIRECTORY = new pf_probe_directory();
    public static final Primitive FILE_DIRECTORY_P = new pf_file_directory_p();

    @DocString(name="file-directory-p", args="pathspec &key (wild-error-p t)", returns="generalized-boolean")
    private static final class pf_file_directory_p
    extends Primitive {
        pf_file_directory_p() {
            super("file-directory-p", Lisp.PACKAGE_EXT, true);
        }

        private LispObject isDirectory(Pathname p) {
            LispObject result = PROBE_DIRECTORY.execute(p);
            return result.equals(Lisp.NIL) ? Lisp.NIL : Lisp.T;
        }

        @Override
        public LispObject execute(LispObject arg) {
            Pathname pathname = Lisp.coerceToPathname(arg);
            if (pathname.isWild()) {
                Lisp.error(new FileError("Fundamentally unable to determine whether a wild pathname is a directory.", pathname));
            }
            return this.isDirectory(pathname);
        }

        @Override
        public LispObject execute(LispObject arg, LispObject wildErrorPKeyword, LispObject wildErrorP) {
            if (!wildErrorPKeyword.equals(Keyword.WILD_ERROR_P)) {
                Lisp.type_error(wildErrorPKeyword, Keyword.WILD_ERROR_P);
            }
            Pathname pathname = Lisp.coerceToPathname(arg);
            if (wildErrorP != Lisp.NIL && pathname.isWild()) {
                Lisp.error(new FileError("Fundamentally to determine whether a wild pathname is a directory.", pathname));
            }
            return this.isDirectory(pathname);
        }
    }

    @DocString(name="probe-directory", args="pathspec", returns="truename")
    private static final class pf_probe_directory
    extends Primitive {
        pf_probe_directory() {
            super("probe-directory", Lisp.PACKAGE_EXT, true);
        }

        @Override
        public LispObject execute(LispObject arg) {
            Pathname defaultedPathname;
            Pathname pathname = Lisp.coerceToPathname(arg);
            if (pathname.isWild()) {
                Lisp.error(new FileError("Cannot probe a wild pathname as a directory.", pathname));
            }
            if ((defaultedPathname = (Pathname)Pathname.MERGE_PATHNAMES.execute(pathname)) instanceof JarPathname) {
                if (defaultedPathname.getName().equals(Lisp.NIL) && defaultedPathname.getType().equals(Lisp.NIL)) {
                    return Symbol.PROBE_FILE.execute(defaultedPathname);
                }
                SimpleString lastDirectory = (SimpleString)Symbol.FILE_NAMESTRING.execute(defaultedPathname);
                LispObject appendedDirectory = defaultedPathname.getDirectory().reverse().push(lastDirectory).reverse();
                defaultedPathname.setDirectory(appendedDirectory);
                return Symbol.PROBE_FILE.execute(defaultedPathname);
            }
            File file = defaultedPathname.getFile();
            if (file == null || !file.isDirectory()) {
                return Lisp.NIL;
            }
            if (defaultedPathname.getName().equals(Lisp.NIL) && defaultedPathname.getType().equals(Lisp.NIL)) {
                return Symbol.PROBE_FILE.execute(defaultedPathname);
            }
            SimpleString lastDirectory = (SimpleString)Symbol.FILE_NAMESTRING.execute(defaultedPathname);
            LispObject appendedDirectory = defaultedPathname.getDirectory().reverse().push(lastDirectory).reverse();
            defaultedPathname.setDirectory(appendedDirectory);
            return Symbol.PROBE_FILE.execute(defaultedPathname);
        }
    }

    @DocString(name="truename", args="pathspec", returns="pathname")
    private static class pf_truename
    extends Primitive {
        pf_truename() {
            super(Symbol.TRUENAME, "filespec");
        }

        @Override
        public LispObject execute(LispObject arg) {
            Pathname p = Lisp.coerceToPathname(arg);
            if (p.isWild()) {
                return Lisp.error(new FileError("Cannot find the TRUENAME for a wild pathname.", p));
            }
            if (p instanceof JarPathname) {
                return JarPathname.truename(p, true);
            }
            if (p instanceof URLPathname) {
                return URLPathname.truename((URLPathname)p, true);
            }
            return Pathname.truename(p, true);
        }
    }

    @DocString(name="probe-file", args="pathspec", returns="truename")
    private static final class pf_probe_file
    extends Primitive {
        pf_probe_file() {
            super(Symbol.PROBE_FILE, "pathspec");
        }

        @Override
        public LispObject execute(LispObject arg) {
            if (arg == null || arg.equals(Lisp.NIL)) {
                return Lisp.NIL;
            }
            Pathname p = Lisp.coerceToPathname(arg);
            if (p.isWild()) {
                return Lisp.error(new FileError("Cannot find the TRUENAME for a wild pathname.", p));
            }
            if (p instanceof JarPathname) {
                return JarPathname.truename(p, false);
            }
            if (p instanceof URLPathname) {
                return URLPathname.truename((URLPathname)p, false);
            }
            return Pathname.truename(p, false);
        }
    }
}

