/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.infobrightoutput;

import com.infobright.etl.model.DataFormat;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.infobrightoutput.InfobrightLoader;
import org.pentaho.di.trans.steps.infobrightoutput.InfobrightLoaderData;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfobrightLoaderMeta
extends TableOutputMeta
implements StepMetaInterface {
    private DataFormat dataFormat;
    private boolean rejectErrors = false;

    public InfobrightLoaderMeta() {
        this.setIgnoreErrors(false);
        this.setTruncateTable(false);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        InfobrightLoader loader = new InfobrightLoader(stepMeta, stepDataInterface, cnr, tr, trans);
        return loader;
    }

    @Override
    public StepDataInterface getStepData() {
        return new InfobrightLoaderData();
    }

    @Override
    public Object clone() {
        InfobrightLoaderMeta retval = (InfobrightLoaderMeta)super.clone();
        return retval;
    }

    public String getInfobrightProductType() {
        return this.dataFormat.getDisplayText();
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Override
    public void setDefault() {
        this.dataFormat = DataFormat.TXT_VARIABLE;
    }

    @Override
    public String getXML() {
        String ret = super.getXML();
        return ret + new String("    " + XMLHandler.addTagValue((String)"data_format", (String)this.dataFormat.toString()));
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        super.loadXML(stepnode, databases, counters);
        this.dataFormat = Enum.valueOf(DataFormat.class, XMLHandler.getTagValue((Node)stepnode, (String)"data_format"));
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        super.readRep(rep, id_step, databases, counters);
        this.dataFormat = Enum.valueOf(DataFormat.class, rep.getStepAttributeString(id_step, "data_format"));
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        super.saveRep(rep, id_transformation, id_step);
        rep.saveStepAttribute(id_transformation, id_step, "data_format", this.dataFormat.toString());
    }

    public boolean isRejectErrors() {
        return this.rejectErrors;
    }

    public void setRejectErrors(boolean rejectErrors) {
        this.rejectErrors = rejectErrors;
    }
}

