/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.vcslinks.cache.impl;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracklink.IssueLinkModel;
import com.almworks.tracklink.TrackLinkCaches;
import com.almworks.tracklink.TrackLinkPlugin;
import com.almworks.tracklink.codelinks.CodeLinkType;
import com.almworks.tracklink.codelinks.cache.ArtifactInfoCache;
import com.almworks.tracklink.codelinks.cache.impl.DataFile;
import com.almworks.tracklink.codelinks.cache.impl.DataInputStream;
import com.almworks.tracklink.codelinks.highlight.CodeParser;
import com.almworks.tracklink.findusages.FindUtils;
import com.almworks.tracklink.vcslinks.ChangeSet;
import com.almworks.tracklink.vcslinks.VCSUtil;
import com.almworks.tracklink.vcslinks.cache.VCSCache;
import com.almworks.tracklink.vcslinks.cache.impl.IndexedRecordList;
import com.almworks.tracklink.vcslinks.cache.impl.VirtualFileRevision;
import com.almworks.tracklink.vcslinks.comments.CommentParser;
import com.almworks.util.Log;
import com.almworks.util.Procedure;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.checkin.DifferenceType;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.XmlSerializerUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@State(name="TL_VCS_CACHE", storages={@Storage(id="TLComponents.TL_COLLECTION_CHACHE", file="$PROJECT_FILE$")})
public class VCSCacheImpl
implements VCSCache,
ProjectComponent,
PersistentStateComponent<ConfigBean> {
    private static final int DEFAULT_REFRESH_PERIOD = 15;
    @Nullable
    private Project myProject;
    @NotNull
    private final Date myLastCheckDate = new Date(0L);
    private final IssueLinkModel myModel;
    private final CodeParser myParser;
    private final ArtifactInfoCache myCache;
    private boolean myUpdateNextTimeFlag = false;
    private IndexedRecordList myUrlCache;
    private IndexedRecordList myRevisionsCache;
    private DataFile myUrlRevisionMap;
    public ConfigBean myConfigBean = new ConfigBean();
    private final TIntObjectHashMap<TIntArrayList> myUrlToRevisionId = new TIntObjectHashMap();
    private TObjectIntHashMap<String> myUrlIds;
    private static final long DAY = 86400000L;
    private static final int MAX_DESCRIPTION_LENGTH = 120;

    public VCSCacheImpl(Project project) {
        this.myProject = project;
        this.myCache = TrackLinkCaches.getInstance().getArtifactInfoCache();
        TrackLinkPlugin plugin = TrackLinkPlugin.getInstance(project);
        this.myModel = plugin.getIssueModel();
        this.myParser = plugin.getParser();
    }

    public void projectOpened() {
    }

    public void projectClosed() {
        this.myProject = null;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("TL_VCS_CACHE" == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/vcslinks/cache/impl/VCSCacheImpl.getComponentName must not return null");
        }
        return "TL_VCS_CACHE";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private long getNextCheckDate() {
        if (this.myLastCheckDate.getTime() == 0L) {
            return 0L;
        }
        return this.myLastCheckDate.getTime() + 900000L;
    }

    @Override
    public long getLastUpdateTime() {
        return this.myLastCheckDate.getTime();
    }

    @Override
    public void updateNextTime() {
        this.myUpdateNextTimeFlag = true;
    }

    @Override
    public boolean isUpdateNeeded() {
        return this.myUpdateNextTimeFlag || this.getNextCheckDate() <= System.currentTimeMillis();
    }

    private void doUpdate() {
        Project project = this.myProject;
        if (this.myParser == null || project == null) {
            return;
        }
        this.ensureInitialized();
        Log.debug("doUpdate()");
        long updateTime = System.currentTimeMillis();
        Date dateBefore = null;
        long longDateAfter = this.myLastCheckDate.getTime();
        Date dateAfter = longDateAfter == 0L ? null : new Date(longDateAfter / 86400000L * 86400000L);
        VCSUtil.getAllChangeSets(project, dateAfter, dateBefore, new Procedure<ChangeSet>(){

            @Override
            public void process(ChangeSet changeSet) {
                Log.debug("got change set " + changeSet);
                CommittedChangeList repositoryVersion = changeSet.getVcsChangeSet();
                String description = repositoryVersion.getComment();
                Collection infos = VCSCacheImpl.this.getArtifactInfos(description);
                Log.debug("getArtifactInfos() = #" + infos.size());
                if (!infos.isEmpty()) {
                    AbstractVcs vcs = changeSet.getVcs();
                    VirtualFile contentRoot = changeSet.getContentRoot();
                    Date date = repositoryVersion.getCommitDate();
                    Collection fileRevisions = repositoryVersion.getChanges();
                    String firstLine = VCSCacheImpl.this.getFirstLine(description);
                    List revisions = VCSCacheImpl.this.getVirtualFileRevisions(fileRevisions, date, firstLine);
                    for (ArtifactInfo info : infos) {
                        VCSCacheImpl.this.put(info.getUrl(), revisions);
                    }
                }
            }
        });
        this.myLastCheckDate.setTime(updateTime);
        this.myUpdateNextTimeFlag = false;
    }

    private String getFirstLine(String description) {
        String inline = StringUtil.convertLineSeparators((String)description).replace('\n', ' ');
        if (inline.length() > 120) {
            int dots;
            inline = inline.substring(0, 120);
            for (dots = 3; dots > 0 && inline.charAt(inline.length() - 4 + dots) == '.'; --dots) {
            }
            for (int i = 0; i < dots; ++i) {
                inline = inline + '.';
            }
            return inline;
        }
        return inline;
    }

    private void put(@NotNull String url, @NotNull List<VirtualFileRevision> revisions) {
        int urlId;
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/vcslinks/cache/impl/VCSCacheImpl.put must not be null");
        }
        if (revisions == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/almworks/tracklink/vcslinks/cache/impl/VCSCacheImpl.put must not be null");
        }
        if (revisions.isEmpty()) {
            return;
        }
        this.myUrlRevisionMap.setDirty();
        if (this.myUrlIds.containsKey((Object)url)) {
            urlId = this.myUrlIds.get((Object)url);
        } else {
            urlId = this.myUrlCache.addUFT8String(url);
            this.myUrlIds.put((Object)url, urlId);
        }
        TIntArrayList revIds = (TIntArrayList)this.myUrlToRevisionId.get(urlId);
        if (revIds == null) {
            revIds = new TIntArrayList();
            this.myUrlToRevisionId.put(urlId, (Object)revIds);
        }
        for (VirtualFileRevision revision : revisions) {
            revIds.add(this.myRevisionsCache.addRecord(revision.getBytes()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Set<VirtualFileRevision> getFiles(String url, @Nullable Boolean refresh) {
        Set<VirtualFileRevision> set;
        Log.debug("getFiles(" + url + ", " + refresh + ")");
        Project project = this.myProject;
        if (project == null) {
            Log.debug("null project");
            set = Collections.emptySet();
            if (set == null) throw new IllegalStateException("@NotNull method com/almworks/tracklink/vcslinks/cache/impl/VCSCacheImpl.getFiles must not return null");
            return set;
        }
        boolean update = refresh != null ? refresh.booleanValue() : this.isUpdateNeeded();
        if (update) {
            this.doUpdate();
        }
        this.ensureInitialized();
        if (!this.myUrlIds.containsKey((Object)url)) {
            set = Collections.emptySet();
            if (set == null) throw new IllegalStateException("@NotNull method com/almworks/tracklink/vcslinks/cache/impl/VCSCacheImpl.getFiles must not return null");
            return set;
        }
        int urlId = this.myUrlIds.get((Object)url);
        TIntArrayList revIds = (TIntArrayList)this.myUrlToRevisionId.get(urlId);
        if (revIds == null) {
            set = Collections.emptySet();
            if (set == null) throw new IllegalStateException("@NotNull method com/almworks/tracklink/vcslinks/cache/impl/VCSCacheImpl.getFiles must not return null");
            return set;
        }
        HashSet<VirtualFileRevision> result = new HashSet<VirtualFileRevision>();
        try {
            for (int i = 0; i < revIds.size(); ++i) {
                VirtualFileRevision revision = VirtualFileRevision.fromBytes(this.myRevisionsCache.getRecord(revIds.get(i)), project);
                if (revision == null) continue;
                result.add(revision);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        set = result;
        if (set != null) return set;
        throw new IllegalStateException("@NotNull method com/almworks/tracklink/vcslinks/cache/impl/VCSCacheImpl.getFiles must not return null");
    }

    @Override
    public Set<String> getAllCachedURLs() {
        Log.debug("getAllCachedURLs()");
        if (!this.isUpdateNeeded()) {
            this.doUpdate();
        }
        return new HashSet<Object>(Arrays.asList(this.myUrlIds.keys()));
    }

    @Override
    public boolean isEmpty() {
        return this.myUrlIds.isEmpty();
    }

    private Collection<ArtifactInfo> getArtifactInfos(String description) {
        if (description == null || description.length() == 0) {
            return Collections.emptyList();
        }
        HashSet<String> urls = new HashSet<String>();
        CommentParser commentParser = new CommentParser(description, this.myModel);
        urls.addAll(commentParser.getUrls());
        HashSet<ArtifactInfo> result = new HashSet<ArtifactInfo>();
        if (this.myCache != null) {
            List<CodeLinkType> referenceTypes = this.myModel.getReferenceTypes();
            CodeLinkType[] codeLinkTypes = referenceTypes.toArray(new CodeLinkType[referenceTypes.size()]);
            for (String url : urls) {
                if (FindUtils.filterCodeLinkTypes(codeLinkTypes, url).length <= 0) continue;
                result.add(this.myCache.getArtifactInfoSnapshot(url));
            }
        }
        return result;
    }

    private List<VirtualFileRevision> getVirtualFileRevisions(Collection<Change> revisionses, @NotNull Date date, String description) {
        if (date == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/almworks/tracklink/vcslinks/cache/impl/VCSCacheImpl.getVirtualFileRevisions must not be null");
        }
        Project project = this.myProject;
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFileRevision> result = new ArrayList<VirtualFileRevision>();
        for (Change revisions : revisionses) {
            VirtualFile virtualFile = ChangesUtil.getFilePath((Change)revisions).getVirtualFile();
            if (virtualFile == null) continue;
            DifferenceType dt = revisions.getType() == Change.Type.NEW ? DifferenceType.INSERTED : (revisions.getType() == Change.Type.DELETED ? DifferenceType.DELETED : DifferenceType.MODIFIED);
            result.add(new VirtualFileRevision(virtualFile, description, date, dt));
        }
        return result;
    }

    private void ensureInitialized() {
        if (this.myRevisionsCache != null && this.myUrlCache != null && this.myUrlRevisionMap != null && this.myUrlIds != null) {
            return;
        }
        assert (this.myRevisionsCache == null && this.myUrlCache == null && this.myUrlRevisionMap == null && this.myUrlIds == null) : "" + this.myRevisionsCache + this.myUrlCache + this.myUrlRevisionMap + this.myUrlIds;
        Project project = this.myProject;
        if (project == null) {
            return;
        }
        File dataHome = TrackLinkPlugin.getSystemHome();
        try {
            this.myUrlCache = IndexedRecordList.newUnique(dataHome, "url", project.hashCode());
            this.myRevisionsCache = IndexedRecordList.newUnique(dataHome, "rev", project.hashCode());
            this.myUrlRevisionMap = DataFile.newUnique(dataHome, "map", project.hashCode());
            this.myUrlIds = new TObjectIntHashMap();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void readExternal() {
        File dataHome = TrackLinkPlugin.getSystemHome();
        try {
            this.myUrlCache = IndexedRecordList.fromConfig(this.myConfigBean.myUrlCacheName, dataHome, "url");
            this.myRevisionsCache = IndexedRecordList.fromConfig(this.myConfigBean.myRevisionsCacheName, dataHome, "rev");
            this.myUrlRevisionMap = DataFile.fromConfig(this.myConfigBean.myUrlRevisionMapName, dataHome, "map");
            if (this.myUrlRevisionMap.length() < 4L) {
                this.myUrlIds = new TObjectIntHashMap();
                this.resetCaches();
                return;
            }
            this.myUrlIds = this.myUrlCache.loadToIdMap(IndexedRecordList.UTF8_STRING_LOADER);
            DataInputStream stream = this.myUrlRevisionMap.getInputStream();
            this.myLastCheckDate.setTime(stream.readLong());
            while (!stream.atEnd()) {
                int urlId = stream.readInt();
                int revId = stream.readInt();
                TIntArrayList revisions = (TIntArrayList)this.myUrlToRevisionId.get(urlId);
                if (revisions == null) {
                    revisions = new TIntArrayList();
                    this.myUrlToRevisionId.put(urlId, (Object)revisions);
                }
                revisions.add(revId);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void resetCaches() {
        this.ensureInitialized();
        this.myUrlCache.reset();
        this.myRevisionsCache.reset();
        this.myUrlRevisionMap.reset();
        this.myLastCheckDate.setTime(0L);
        this.myUrlIds = new TObjectIntHashMap();
    }

    public void writeExternal() {
        if (this.myUrlCache == null || this.myRevisionsCache == null || this.myUrlRevisionMap == null) {
            return;
        }
        this.myConfigBean.myUrlCacheName = this.myUrlCache.getReferenceName();
        this.myConfigBean.myRevisionsCacheName = this.myRevisionsCache.getReferenceName();
        this.myConfigBean.myUrlRevisionMapName = this.myUrlRevisionMap.getReferenceName();
        try {
            this.myUrlCache.flush();
            this.myRevisionsCache.flush();
            if (this.myUrlRevisionMap.isDirty()) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                DataInputStream.writeLong(stream, this.myLastCheckDate.getTime());
                for (int urlId : this.myUrlToRevisionId.keys()) {
                    TIntArrayList revIds = (TIntArrayList)this.myUrlToRevisionId.get(urlId);
                    for (int i = 0; i < revIds.size(); ++i) {
                        DataInputStream.writeInt(stream, urlId);
                        DataInputStream.writeInt(stream, revIds.get(i));
                    }
                }
                this.myUrlRevisionMap.write(stream.toByteArray());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ConfigBean getState() {
        this.writeExternal();
        return this.myConfigBean;
    }

    public void loadState(ConfigBean state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myConfigBean);
        this.readExternal();
    }

    public static class ConfigBean {
        public String myUrlRevisionMapName;
        public String myRevisionsCacheName;
        public String myUrlCacheName;
    }
}

