/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.vcslinks.comments;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.GenericKeys;
import com.almworks.tracklink.CheckinOptions;
import com.almworks.tracklink.IssueLinkModel;
import com.almworks.tracklink.codelinks.CodeLinkType;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentMaker {
    @NotNull
    private final String myUserComment;
    private final Collection<ArtifactInfo> myInfos;
    private final IssueLinkModel myModel;
    private final CheckinOptions myCheckinOptions;

    public CommentMaker(String initialComment, Collection<ArtifactInfo> infos, IssueLinkModel model, CheckinOptions checkinOptions) {
        this.myCheckinOptions = checkinOptions;
        this.myUserComment = initialComment == null ? "" : initialComment.trim();
        this.myInfos = infos == null ? Collections.emptySet() : infos;
        this.myModel = model;
    }

    public String getMessage() {
        StringBuffer result = new StringBuffer();
        if (!this.myCheckinOptions.isReplaceUserComment()) {
            result.append(this.myUserComment);
        }
        if (!this.myInfos.isEmpty()) {
            List<Pair<String, String>> idSummaryPairs = this.getIdSummaryPairs();
            if (this.myCheckinOptions.isAllowMultiline()) {
                this.buildMultilineMessage(result, idSummaryPairs);
            } else {
                this.buildOnelineMessage(result, idSummaryPairs);
            }
        }
        return result.toString();
    }

    private List<Pair<String, String>> getIdSummaryPairs() {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        List<CodeLinkType> linkTypes = this.myModel.getReferenceTypes();
        ArrayList<ArtifactInfo> infos = new ArrayList<ArtifactInfo>(this.myInfos);
        for (CodeLinkType linkType : linkTypes) {
            Iterator<ArtifactInfo> ii = infos.iterator();
            while (ii.hasNext()) {
                ArtifactInfo info = ii.next();
                String visualID = linkType.getVisualID(info.getUrl());
                if (visualID == null) continue;
                ii.remove();
                String summary = info.getApplicableKeys().contains(GenericKeys.SUMMARY) ? (String)info.getPresentation(GenericKeys.SUMMARY) : "";
                result.add((Pair<String, String>)Pair.create((Object)visualID, (Object)summary));
            }
        }
        return result;
    }

    private void buildMultilineMessage(StringBuffer result, List<Pair<String, String>> idSummaryPairs) {
        int maximumColumns = this.myCheckinOptions.getMaximumColumns();
        boolean includeSummary = this.myCheckinOptions.isIncludeSummary();
        for (Pair<String, String> pair : idSummaryPairs) {
            if (result.length() > 0) {
                result.append('\n');
            }
            String id = (String)pair.getFirst();
            String summary = (String)pair.getSecond();
            result.append(id);
            if (includeSummary && summary.length() > 0) {
                result.append(' ');
                int max = maximumColumns - (id.length() + 1);
                if (summary.length() > max) {
                    result.append(summary.substring(0, Math.max(0, max - 3))).append("...");
                } else {
                    result.append(summary);
                }
            }
            result.append(' ');
        }
    }

    private void buildOnelineMessage(StringBuffer result, List<Pair<String, String>> idSummaryPairs) {
        if (result.length() > 0) {
            result.append(' ');
        }
        boolean first = true;
        for (Pair<String, String> pair : idSummaryPairs) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            result.append((String)pair.getFirst());
        }
        if (this.myCheckinOptions.isIncludeSummary()) {
            int maximumColumns = this.myCheckinOptions.getMaximumColumns();
            int max = maximumColumns - (result.length() + 1);
            StringBuffer summaries = new StringBuffer();
            for (Pair<String, String> pair : idSummaryPairs) {
                if (summaries.length() > 0) {
                    summaries.append("; ");
                }
                summaries.append((String)pair.getSecond());
            }
            if (idSummaryPairs.size() == 1) {
                this.appendSummaries(result, max, summaries, " ", "");
            } else {
                this.appendSummaries(result, max - 2, summaries, " (", ")");
            }
        }
    }

    private void appendSummaries(StringBuffer result, int max, StringBuffer summaries, String open, String close) {
        if (summaries.length() > max) {
            if (max > 5) {
                result.append(open).append(summaries.substring(0, Math.max(0, max - 3))).append("...").append(close);
            }
        } else {
            result.append(open).append(summaries).append(close);
        }
    }
}

