/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.zeno;

import java.util.ArrayList;
import java.util.Iterator;

public class ZenoChainIterator<U>
implements Iterator<U> {
    private int majorIndex = 0;
    private int minorIndex = 0;
    private final ArrayList<ArrayList<U>> masterList;

    public ZenoChainIterator(ArrayList<ArrayList<U>> masterList) {
        this.masterList = masterList;
    }

    @Override
    public boolean hasNext() {
        return this.majorIndex < this.masterList.size() && this.minorIndex < this.masterList.get(this.majorIndex).size();
    }

    @Override
    public U next() {
        ArrayList<U> currentSegment = this.masterList.get(this.majorIndex);
        U result = currentSegment.get(this.minorIndex);
        if (++this.minorIndex >= currentSegment.size()) {
            ++this.majorIndex;
            this.minorIndex = 0;
        }
        return result;
    }
}

