/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.util;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import java.util.HashMap;
import java.util.Map;

public class PropertyMapBuilder {
    private Map<PropertyId<?>, Object> map;
    private PropertyId<?>[] keys;

    public PropertyMapBuilder() {
        this.map = new HashMap();
    }

    public PropertyMapBuilder(PropertyMap propertyMap) {
        if (propertyMap instanceof PropertyMapImpl) {
            PropertyMapImpl propertyMapImpl = (PropertyMapImpl)propertyMap;
            this.map = propertyMapImpl.map;
            this.keys = propertyMapImpl.keys;
        } else {
            this.map = new HashMap();
            this.add(propertyMap);
        }
    }

    public void add(PropertyMap propertyMap) {
        int n = propertyMap.size();
        for (int i = 0; i < n; ++i) {
            this.copy(propertyMap.getKey(i), propertyMap);
        }
    }

    private <T> void copy(PropertyId<T> propertyId, PropertyMap propertyMap) {
        this.put(propertyId, propertyMap.get(propertyId));
    }

    private void lock() {
        if (this.keys != null) {
            return;
        }
        this.keys = new PropertyId[this.map.size()];
        int n = 0;
        for (PropertyId<?> propertyId : this.map.keySet()) {
            this.keys[n++] = propertyId;
        }
    }

    private void copyIfLocked() {
        if (this.keys == null) {
            return;
        }
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.keys.length; ++i) {
            hashMap.put(this.keys[i], this.map.get(this.keys[i]));
        }
        this.map = hashMap;
        this.keys = null;
    }

    public PropertyMap toPropertyMap() {
        this.lock();
        return new PropertyMapImpl(this.map, this.keys);
    }

    public <T> T put(PropertyId<T> propertyId, T t) {
        this.copyIfLocked();
        Class<T> clazz = propertyId.getValueClass();
        if (t == null) {
            return clazz.cast(this.map.remove(propertyId));
        }
        return clazz.cast(this.map.put(propertyId, clazz.cast(t)));
    }

    public <T> T get(PropertyId<T> propertyId) {
        return propertyId.getValueClass().cast(this.map.get(propertyId));
    }

    public boolean contains(PropertyId<?> propertyId) {
        return this.map.get(propertyId) != null;
    }

    private static class PropertyMapImpl
    implements PropertyMap {
        private final Map<PropertyId<?>, Object> map;
        private final PropertyId<?>[] keys;

        private PropertyMapImpl(Map<PropertyId<?>, Object> map, PropertyId<?>[] propertyIdArray) {
            this.map = map;
            this.keys = propertyIdArray;
        }

        @Override
        public <T> T get(PropertyId<T> propertyId) {
            return propertyId.getValueClass().cast(this.map.get(propertyId));
        }

        @Override
        public int size() {
            return this.keys.length;
        }

        @Override
        public boolean contains(PropertyId<?> propertyId) {
            return this.map.get(propertyId) != null;
        }

        @Override
        public PropertyId<?> getKey(int n) {
            return this.keys[n];
        }
    }
}

