/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon;

import java.io.PrintStream;
import org.jboss.galleon.MessageWriter;

public class DefaultMessageWriter
implements MessageWriter {
    private final boolean verbose;
    private final PrintStream stdout;
    private final PrintStream stderr;
    private final boolean closeStreams;

    public DefaultMessageWriter() {
        this(System.out, System.err);
    }

    public DefaultMessageWriter(PrintStream stdout, PrintStream stderr) {
        this(stdout, stderr, false);
    }

    public DefaultMessageWriter(PrintStream stdout, PrintStream stderr, boolean verbose) {
        this(stdout, stderr, verbose, false);
    }

    public DefaultMessageWriter(PrintStream stdout, PrintStream stderr, boolean verbose, boolean closeStreams) {
        this.stdout = stdout;
        this.stderr = stderr;
        this.verbose = verbose;
        this.closeStreams = closeStreams;
    }

    public static DefaultMessageWriter getDefaultInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void verbose(Throwable cause, CharSequence message) {
        if (this.isVerboseEnabled()) {
            if (message != null) {
                this.stdout.println(message);
            }
            if (cause != null) {
                cause.printStackTrace(this.stdout);
            }
        }
    }

    @Override
    public void print(Throwable cause, CharSequence message) {
        if (message != null) {
            this.stdout.println(message);
        }
        if (cause != null) {
            cause.printStackTrace(this.stdout);
        }
    }

    @Override
    public void error(Throwable cause, CharSequence message) {
        if (message != null) {
            this.stderr.println(message);
        }
        if (cause != null) {
            cause.printStackTrace(this.stderr);
        }
    }

    @Override
    public boolean isVerboseEnabled() {
        return this.verbose;
    }

    @Override
    public void close() throws Exception {
        if (this.closeStreams) {
            try {
                this.stdout.close();
            }
            finally {
                this.stderr.close();
            }
        }
    }

    private static class Holder {
        static final DefaultMessageWriter INSTANCE = new DefaultMessageWriter();

        private Holder() {
        }
    }
}

