/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.installation;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.aesh.command.option.Option;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.Util;
import org.jboss.galleon.cli.cmd.CommandWithInstallationDirectory;
import org.jboss.galleon.util.PathsUtils;

public abstract class AbstractInstallationCommand
extends PmSessionCommand
implements CommandWithInstallationDirectory {
    @Option(name="dir", required=false, description="Installation directory")
    private File targetDirArg;

    public File getTargetDirArg() {
        return this.targetDirArg;
    }

    @Override
    public Path getInstallationDirectory(AeshContext context) {
        try {
            return Util.lookupInstallationDir(context, this.getTargetDirArg() == null ? null : this.getTargetDirArg().toPath());
        }
        catch (ProvisioningException ex) {
            return null;
        }
    }

    @Override
    protected String getCoreVersion(PmSession session) throws ProvisioningException {
        Path home = this.getInstallationDirectory(session.getAeshContext());
        if (home == null || !Files.exists(home, new LinkOption[0])) {
            throw new ProvisioningException("Not a galleon installation " + this.targetDirArg);
        }
        Path prov = PathsUtils.getProvisioningXml(home);
        return session.getGalleonBuilder().getCoreVersion(prov);
    }
}

