/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.maingrp;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.utils.Config;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.APIVersion;
import org.jboss.galleon.api.GalleonFeaturePackLayout;
import org.jboss.galleon.api.GalleonProvisioningLayout;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.GalleonCommandExecutionContext;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.UniverseManager;
import org.jboss.galleon.cli.Util;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Producer;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.util.PathsUtils;

@CommandDefinition(name="find", description="Find feature pack locations that match the pattern")
public class FindCommand
extends PmSessionCommand {
    @Argument(description="Feature pack location and/or layer pattern. eg: wildfly:*.Final to search for all Final builds")
    private String pattern;
    @Option(description="Comma separated list of layer name patterns. eg: ejb* to search for all feature-pack that offer an ejb layer. If no feature pack location pattern is set, search into the final releases", name="layers")
    private String layerPattern;
    @Option(required=false, name="universe", description="Provide a universe id in order to search for feature packs located in not installed universe")
    private String fromUniverse;
    @Option(required=false, name="resolved-only", hasValue=false, description="Look-up in resolved feature-packs only")
    private Boolean resolvedOnly;

    /*
     * WARNING - void declaration
     */
    @Override
    protected void runCommand(final PmCommandInvocation invoc) throws CommandExecutionException {
        if (this.pattern == null && this.layerPattern == null) {
            throw new CommandExecutionException(CliErrors.missingPattern());
        }
        if (this.pattern == null) {
            this.pattern = ".Final";
        }
        final HashMap results = new HashMap();
        final HashMap<UniverseSpec, Set<String>> exceptions = new HashMap<UniverseSpec, Set<String>>();
        if (!this.pattern.endsWith("*")) {
            this.pattern = this.pattern + "*";
        }
        this.pattern = this.pattern.replaceAll("\\*", ".*");
        final ArrayList<Pattern> layersCompiledPatterns = new ArrayList<Pattern>();
        if (this.layerPattern != null) {
            for (String string : this.layerPattern.split(",")) {
                void var8_14;
                if (!string.endsWith("*")) {
                    String string2 = string + "*";
                }
                String string3 = var8_14.replaceAll("\\*", ".*");
                layersCompiledPatterns.add(Pattern.compile(string3));
            }
        }
        final boolean containsFrequency = this.pattern.contains("/");
        final Pattern compiledPattern = Pattern.compile(this.pattern);
        Path installation = null;
        try {
            installation = Util.lookupInstallationDir(invoc.getConfiguration().getAeshContext(), null);
        }
        catch (ProvisioningException provisioningException) {
            // empty catch block
        }
        final Path path = installation;
        String coreVersion = APIVersion.getVersion();
        GalleonCommandExecutionContext bridge = null;
        try {
            if (path != null) {
                Path prov = PathsUtils.getProvisioningXml(path);
                coreVersion = invoc.getPmSession().getGalleonBuilder().getCoreVersion(prov);
            }
            bridge = invoc.getPmSession().getGalleonContext(coreVersion);
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(invoc.getPmSession(), ex.getLocalizedMessage(), ex);
        }
        final GalleonCommandExecutionContext finalBridge = bridge;
        final Integer[] numResults = new Integer[]{0};
        ProgressTracker<FeaturePackLocation.FPID> track = null;
        if (bridge.isTrackersEnabled()) {
            track = bridge.newFindTracker(invoc);
        }
        final ProgressTracker<FeaturePackLocation.FPID> tracker = track;
        bridge.unregisterTrackers();
        try {
            final Comparator<Result> locComparator = new Comparator<Result>(){

                @Override
                public int compare(Result o1, Result o2) {
                    return o1.location.toString().compareTo(o2.location.toString());
                }
            };
            UniverseManager.UniverseVisitor visitor = new UniverseManager.UniverseVisitor(){

                @Override
                public void visit(Producer<?> producer, FeaturePackLocation loc) {
                    try {
                        if (FindCommand.this.resolvedOnly.booleanValue() && !producer.getChannel(loc.getChannelName()).isResolved(loc)) {
                            return;
                        }
                    }
                    catch (ProvisioningException ex) {
                        this.exception(loc.getUniverse(), ex);
                        return;
                    }
                    if (tracker != null) {
                        tracker.processing(loc.getFPID());
                    }
                    FeaturePackLocation exposedLoc = finalBridge.getExposedLocation(path, loc);
                    boolean canonicalMatch = compiledPattern.matcher(loc.toString()).matches();
                    boolean exposedMatch = compiledPattern.matcher(exposedLoc.toString()).matches();
                    if ((canonicalMatch || exposedMatch) && (containsFrequency && loc.getFrequency() != null || !containsFrequency && loc.getFrequency() == null)) {
                        Result result = exposedMatch ? new Result(exposedLoc) : new Result(loc);
                        if (!layersCompiledPatterns.isEmpty()) {
                            try {
                                GalleonFeaturePackConfig config = GalleonFeaturePackConfig.forLocation(loc);
                                GalleonProvisioningConfig provisioning = ((GalleonProvisioningConfig.Builder)GalleonProvisioningConfig.builder().addFeaturePackDep(config)).build();
                                HashSet<ConfigId> layers = new HashSet<ConfigId>();
                                try (Provisioning p = invoc.getPmSession().getGalleonBuilder().newProvisioningBuilder(provisioning).build();
                                     GalleonProvisioningLayout layout = p.newProvisioningLayout(provisioning);){
                                    for (GalleonFeaturePackLayout l : layout.getOrderedFeaturePacks()) {
                                        layers.addAll(l.loadLayers());
                                    }
                                }
                                for (ConfigId l : layers) {
                                    for (Pattern p : layersCompiledPatterns) {
                                        if (!p.matcher(l.getName()).matches()) continue;
                                        result.layers.add(l);
                                    }
                                }
                                if (!result.layers.isEmpty()) {
                                    TreeSet<Result> locations = (TreeSet<Result>)results.get(loc.getUniverse());
                                    if (locations == null) {
                                        locations = new TreeSet<Result>(locComparator);
                                        results.put(loc.getUniverse(), locations);
                                    }
                                    locations.add(result);
                                    numResults[0] = numResults[0] + 1;
                                }
                            }
                            catch (IOException | ProvisioningException ex) {
                                this.exception(loc.getUniverse(), ex);
                            }
                        } else {
                            TreeSet<Result> locations = (TreeSet<Result>)results.get(loc.getUniverse());
                            if (locations == null) {
                                locations = new TreeSet<Result>(locComparator);
                                results.put(loc.getUniverse(), locations);
                            }
                            locations.add(result);
                            numResults[0] = numResults[0] + 1;
                        }
                    }
                }

                @Override
                public void exception(UniverseSpec spec, Exception ex) {
                    HashSet<String> set = (HashSet<String>)exceptions.get(spec);
                    if (set == null) {
                        set = new HashSet<String>();
                        exceptions.put(spec, set);
                    }
                    set.add(ex.getLocalizedMessage() == null ? ex.getMessage() : ex.getLocalizedMessage());
                }
            };
            if (tracker != null) {
                tracker.starting(-1L);
            }
            if (this.fromUniverse == null) {
                bridge.visitAllUniverses(visitor, true, path);
            } else {
                invoc.getPmSession().getUniverse().visitUniverse(UniverseSpec.fromString(this.fromUniverse), visitor, true);
            }
            if (tracker != null) {
                tracker.complete();
            }
            FindCommand.printExceptions(invoc, exceptions);
            invoc.println(Config.getLineSeparator() + "Found " + numResults[0] + " feature pack location" + (numResults[0] > 1 ? "s." : "."));
            for (Map.Entry entry : results.entrySet()) {
                for (Result loc : (Set)entry.getValue()) {
                    invoc.println(loc.toString());
                }
            }
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(ex.getLocalizedMessage());
        }
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.PROVISIONING;
    }

    public static void printExceptions(PmCommandInvocation invoc, Map<UniverseSpec, Set<String>> exceptions) {
        if (!exceptions.isEmpty()) {
            invoc.println("Some exceptions occured while accessing universes.");
        }
        for (Map.Entry<UniverseSpec, Set<String>> entry : exceptions.entrySet()) {
            for (String ex : entry.getValue()) {
                invoc.println(ex + " in " + entry.getKey());
            }
        }
    }

    private static class Result {
        private final FeaturePackLocation location;
        private final Set<ConfigId> layers = new HashSet<ConfigId>();

        Result(FeaturePackLocation location) {
            this.location = location;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.location.toString());
            if (!this.layers.isEmpty()) {
                builder.append(" layers[ ");
                for (ConfigId l : this.layers) {
                    builder.append(l.getModel()).append("/").append(l.getName()).append(" ");
                }
                builder.append("]");
            }
            return builder.toString();
        }
    }
}

