/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.ldap.AuthenticationProviderService;
import org.apache.guacamole.auth.ldap.LDAPAuthenticationProviderModule;
import org.apache.guacamole.auth.ldap.user.LDAPAuthenticatedUser;
import org.apache.guacamole.net.auth.AbstractAuthenticationProvider;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.TokenInjectingUserContext;
import org.apache.guacamole.net.auth.UserContext;

public class LDAPAuthenticationProvider
extends AbstractAuthenticationProvider {
    public static final String ROOT_CONNECTION_GROUP = "ROOT";
    private final Injector injector = Guice.createInjector((Module[])new Module[]{new LDAPAuthenticationProviderModule((AuthenticationProvider)this)});

    public String getIdentifier() {
        return "ldap";
    }

    public AuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        AuthenticationProviderService authProviderService = (AuthenticationProviderService)this.injector.getInstance(AuthenticationProviderService.class);
        return authProviderService.authenticateUser(credentials);
    }

    public UserContext getUserContext(AuthenticatedUser authenticatedUser) throws GuacamoleException {
        AuthenticationProviderService authProviderService = (AuthenticationProviderService)this.injector.getInstance(AuthenticationProviderService.class);
        return authProviderService.getUserContext(authenticatedUser);
    }

    public UserContext decorate(UserContext context, AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleException {
        if (!(authenticatedUser instanceof LDAPAuthenticatedUser)) {
            return context;
        }
        return new TokenInjectingUserContext(context, ((LDAPAuthenticatedUser)authenticatedUser).getTokens());
    }
}

