'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) ScrolledListBox.n 1.21 94/12/17 16:04:44
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" @(#) man.macros 1.1 94/08/09 13:07:19
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tk    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'iwid'      .TH "\\$1" 1 "\\*(^3"  Tk    "[incr Widgets]"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.TH iwidgets::scrolledcanvas iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
iwidgets::scrolledcanvas \- Create and manipulate scrolled canvas widgets
.SH SYNOPSIS
\fBiwidgets::scrolledcanvas\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- iwidgets::Labeledwidget <- iwidgets::Scrolledwidget <- iwidgets::Scrolledcanvas
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fB
activeBackground    background         borderWidth       cursor
exportSelection     font               foreground        highlightColor
highlightThickness  insertBorderWidth  insertOffTime     insertOnTime
insertWidth         relief             selectBackground  selectBorderWidth
selectForeground\fR	
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBcloseEnough\fR	\fBconfine\fR	\fBscrollRegion\fR	\fBxScrollIncrement\fR
\fByScrollIncrement\fR
.fi
.LP
See the "canvas" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBactiveRelief\fR	\fBelementBorderWidth\fR	\fBjump\fR	\fBtroughColor\fR
.fi
.LP
See the "scrollbar" widget manual entry for details on the above
associated options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBdisabledForeground\fR	\fBlabelBitmap\fR	\fBlabelFont\fR	\fBlabelImage\fR
\fBlabelMargin\fR	\fBlabelPos\fR	\fBlabelText\fR	\fBlabelVariable\fR
\fBstate\fR	\fBsticky\fR
.fi
.LP
See the "labeledwidget" class manual entry for details on the inherited options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBautoMargin\fR
Class:	\fBAutoMargin\fR
Command-Line Switch:	\fB-automargin\fR
.fi
.IP
Specifies the autoresize extra margin to reserve.  This option is only
effective with autoresize turned on.  The default is 10.
.LP
.nf
Name:	\fBautoResize\fR
Class:	\fBAutoResize\fR
Command-Line Switch:	\fB-autoresize\fR
.fi
.IP
Automatically adjusts the scrolled region to be the bounding 
box covering all the items in the canvas following the execution 
of any method which creates or destroys items.  Thus, as new 
items are added, the scrollbars adjust accordingly.
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB-height\fR
.fi
.IP
Specifies the height of the scrolled canvas widget in any of the forms 
acceptable to \fBTk_GetPixels\fR.  The default height is 30 pixels.
.LP
.nf
Name:	\fBhscrollMode\fR
Class:	\fBScrollMode\fR
Command-Line Switch:	\fB-hscrollmode\fR
.fi
.IP
Specifies the the display mode to be used for the horizontal
scrollbar: \fBstatic, dynamic,\fR or \fBnone\fR.  In static mode, the 
scroll bar is displayed at all times.  Dynamic mode displays the
scroll bar as required, and none disables the scroll bar display.  The 
default is static.
.LP
.nf
Name:	\fBsbWidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-sbwidth\fR
.fi
.IP
Specifies the width of the scrollbar in any of the forms acceptable 
to \fBTk_GetPixels\fR.  The default width is 15 pixels..
.LP
.nf
Name:	\fBscrollMargin\fR
Class:	\fBScrollMargin\fR
Command-Line Switch:	\fB-scrollmargin\fR
.fi
.IP
Specifies the distance between the canvas and scrollbar in any of the 
forms acceptable to \fBTk_GetPixels\fR.  The default is 3 pixels.
.LP
.nf
Name:	\fBtextBackground\fR
Class:	\fBBackground\fR
Command-Line Switch \fB-textbackground\fR
.fi
.IP
Specifies the background color for the canvas.  This allows the background 
within the canvas to be different from the normal background color.
.LP
.nf
Name:	\fBvscrollMode\fR
Class:	\fBScrollMode\fR
Command-Line Switch:	\fB-vscrollmode\fR
.fi
.IP
Specifies the the display mode to be used for the vertical
scrollbar: \fBstatic, dynamic,\fR or \fBnone\fR.  In static mode, the 
scroll bar is displayed at all times.  Dynamic mode displays the 
scroll bar as required, and none disables the scroll bar display.  The 
default is static.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-width\fR
.fi
.IP
Specifies the width of the scrolled canvas widget in any of the forms 
acceptable to \fBTk_GetPixels\fR.  The default height is 30 pixels.
.BE

.SH DESCRIPTION
.PP
The \fBiwidgets::scrolledcanvas\fR command creates 
a scrolled canvas with additional options to manage
horizontal and vertical scrollbars.  This includes options to control
which scrollbars are displayed and the method, i.e. statically or
dynamically.

.SH "METHODS"
.PP
The \fBiwidgets::scrolledcanvas\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for scrolledcanvas widgets:
.SH "ASSOCIATED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBaddtag\fR	\fBbbox\fR	\fBbind\fR	\fBcanvasx\fR
\fBcanvasy\fB	\fBcoords\fR	\fBcreate\fR	\fBdchars\fR
\fBdelete\fR	\fBdtag\fR	\fBfind\fR	\fBfocus\fR
\fBgettags\fR	\fBicursor\fR	\fBindex\fR	\fBinsert\fR
\fBitemconfigure\fR	\fBlower\fR	\fBmove\fR	\fBpostscript\fR
\fBraise\fR	\fBscale\fR	\fBscan\fR	\fBselect\fR
\fBtype\fR	\fBxview\fR	\fByview\fR
.fi
.LP
See the "canvas" manual entry for details on the associated methods.

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::scrolledcanvas\fR
command.
.TP
\fIpathName \fBchildsite\fR
Returns the child site widget path name.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::scrolledcanvas\fR
command.
.TP
\fIpathName \fBjustify \fIdirection\fR
Justifies the canvas contents via the scroll bars in one of four directions:
\fBleft\fR, \fBright\fR, \fBtop\fR, or \fBbottom\fR.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBcanvas\fR
Class:	\fBCanvas\fR
.fi
.IP
The canvas component is the canvas widget.  See the "canvas" widget 
manual entry for details on the canvas component item.
.LP
.nf
Name:	\fBhorizsb\fR
Class:	\fBScrollbar\fR
.fi
.IP
The horizsb component is the horizontal scroll bar.  See the "ScrollBar" 
widget manual entry for details on the horizsb component item.
.LP
.nf
Name:	\fBvertsb\fR
Class:	\fBScrollbar\fR
.fi
.IP
The vertsb component is the vertical scroll bar.  See the "ScrollBar" widget 
manual entry for details on the vertsb component item.
.fi

.SH EXAMPLE
.DS
  package require Iwidgets 4.0
  iwidgets::scrolledcanvas .sc 

  .sc create rectangle 100 100 400 400 -fill red
  .sc create rectangle 300 300 600 600 -fill green
  .sc create rectangle 200 200 500 500 -fill blue

  pack .sc -padx 10 -pady 10 -fill both -expand yes
.DE
.SH AUTHOR
Mark L. Ulferts
.SH KEYWORDS
scrolledcanvas, canvas, widget
