/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jd.gui.api.model.TreeNodeData;

public class List
extends JList {
    public List() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        KeyStroke ctrlA = KeyStroke.getKeyStroke(65, toolkit.getMenuShortcutKeyMask());
        KeyStroke ctrlC = KeyStroke.getKeyStroke(67, toolkit.getMenuShortcutKeyMask());
        KeyStroke ctrlV = KeyStroke.getKeyStroke(86, toolkit.getMenuShortcutKeyMask());
        InputMap inputMap = this.getInputMap();
        inputMap.put(ctrlA, "none");
        inputMap.put(ctrlC, "none");
        inputMap.put(ctrlV, "none");
        this.setCellRenderer(new Renderer());
    }

    protected class Renderer
    implements ListCellRenderer {
        protected Color textSelectionColor;
        protected Color backgroundSelectionColor;
        protected Color textNonSelectionColor;
        protected Color backgroundNonSelectionColor;
        protected JLabel label = new JLabel();

        public Renderer() {
            this.label.setOpaque(true);
            this.textSelectionColor = UIManager.getColor("List.dropCellForeground");
            this.backgroundSelectionColor = UIManager.getColor("List.dropCellBackground");
            this.textNonSelectionColor = UIManager.getColor("List.foreground");
            this.backgroundNonSelectionColor = UIManager.getColor("List.background");
            Insets margins = UIManager.getInsets("List.contentMargins");
            if (this.textSelectionColor == null) {
                this.textSelectionColor = List.this.getSelectionForeground();
            }
            if (this.backgroundSelectionColor == null) {
                this.backgroundSelectionColor = List.this.getSelectionBackground();
            }
            if (margins != null) {
                this.label.setBorder(BorderFactory.createEmptyBorder(margins.top, margins.left, margins.bottom, margins.right));
            } else {
                this.label.setBorder(BorderFactory.createEmptyBorder(0, 2, 1, 2));
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            Object data = ((DefaultMutableTreeNode)value).getUserObject();
            if (data instanceof TreeNodeData) {
                TreeNodeData tnd = (TreeNodeData)data;
                this.label.setIcon(tnd.getIcon());
                this.label.setText(tnd.getLabel());
            } else {
                this.label.setIcon(null);
                this.label.setText("" + data);
            }
            if (selected) {
                this.label.setForeground(this.textSelectionColor);
                this.label.setBackground(this.backgroundSelectionColor);
            } else {
                this.label.setForeground(this.textNonSelectionColor);
                this.label.setBackground(this.backgroundNonSelectionColor);
            }
            return this.label;
        }
    }
}

