/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.Point;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.IndexesChangeListener;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.util.index.IndexesUtil;
import org.jd.gui.util.io.TextReader;
import org.jd.gui.view.component.HyperlinkPage;

public class ManifestFilePage
extends HyperlinkPage
implements UriGettable,
IndexesChangeListener {
    protected API api;
    protected Container.Entry entry;
    protected Collection<Future<Indexes>> collectionOfFutureIndexes = Collections.emptyList();

    public ManifestFilePage(API api, Container.Entry entry) {
        String internalTypeName;
        String typeName;
        int endIndex;
        int startIndex;
        this.api = api;
        this.entry = entry;
        String text = TextReader.getText(entry.getInputStream());
        int startLineIndex = text.indexOf("Main-Class:");
        if (startLineIndex != -1) {
            startIndex = this.skipSeparators(text, startLineIndex + "Main-Class:".length());
            endIndex = this.searchEndIndexOfValue(text, startLineIndex, startIndex);
            typeName = text.substring(startIndex, endIndex);
            internalTypeName = typeName.replace('.', '/');
            this.addHyperlink(new ManifestHyperlinkData(startIndex, endIndex, internalTypeName + "-main-([Ljava/lang/String;)V"));
        }
        if ((startLineIndex = text.indexOf("Premain-Class:")) != -1) {
            startIndex = this.skipSeparators(text, startLineIndex + "Premain-Class:".length());
            endIndex = this.searchEndIndexOfValue(text, startLineIndex, startIndex);
            typeName = text.substring(startIndex, endIndex);
            internalTypeName = typeName.replace('.', '/');
            this.addHyperlink(new ManifestHyperlinkData(startIndex, endIndex, internalTypeName + "-premain-(*)?"));
        }
        this.setText(text);
    }

    public int skipSeparators(String text, int index) {
        int length = text.length();
        block3: while (index < length) {
            switch (text.charAt(index)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++index;
                    continue block3;
                }
            }
            return index;
        }
        return index;
    }

    public int searchEndIndexOfValue(String text, int startLineIndex, int startIndex) {
        int index;
        int length = text.length();
        block4: for (index = startIndex; index < length; ++index) {
            switch (text.charAt(index)) {
                case '\r': {
                    if (index - startLineIndex >= 70 && index + 1 < length && text.charAt(index + 1) == ' ') {
                        startLineIndex = index + 1;
                        continue block4;
                    }
                    if (index - startLineIndex >= 70 && index + 2 < length && text.charAt(index + 1) == '\n' && text.charAt(index + 2) == ' ') {
                        startLineIndex = ++index + 1;
                        continue block4;
                    }
                    return index;
                }
                case '\n': {
                    if (index - startLineIndex >= 70 && index + 1 < length && text.charAt(index + 1) == ' ') {
                        startLineIndex = index + 1;
                        continue block4;
                    }
                    return index;
                }
            }
        }
        return index;
    }

    @Override
    protected boolean isHyperlinkEnabled(HyperlinkPage.HyperlinkData hyperlinkData) {
        return ((ManifestHyperlinkData)hyperlinkData).enabled;
    }

    @Override
    protected void openHyperlink(int x, int y, HyperlinkPage.HyperlinkData hyperlinkData) {
        block7: {
            ManifestHyperlinkData data = (ManifestHyperlinkData)hyperlinkData;
            if (data.enabled) {
                try {
                    Point location = this.textArea.getLocationOnScreen();
                    int offset = this.textArea.viewToModel(new Point(x - location.x, y - location.y));
                    URI uri = this.entry.getUri();
                    this.api.addURI(new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), "position=" + offset, null));
                    String text = this.getText();
                    String textLink = ManifestFilePage.getValue(text, hyperlinkData.startPosition, hyperlinkData.endPosition);
                    String internalTypeName = textLink.replace('.', '/');
                    List<Container.Entry> entries = IndexesUtil.findInternalTypeName(this.collectionOfFutureIndexes, internalTypeName);
                    String rootUri = this.entry.getContainer().getRoot().getUri().toString();
                    ArrayList<Container.Entry> sameContainerEntries = new ArrayList<Container.Entry>();
                    for (Container.Entry entry : entries) {
                        if (!entry.getUri().toString().startsWith(rootUri)) continue;
                        sameContainerEntries.add(entry);
                    }
                    if (sameContainerEntries.size() > 0) {
                        this.api.openURI(x, y, sameContainerEntries, null, data.fragment);
                    } else if (entries.size() > 0) {
                        this.api.openURI(x, y, entries, null, data.fragment);
                    }
                }
                catch (URISyntaxException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block7;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public URI getUri() {
        return this.entry.getUri();
    }

    @Override
    public String getFileName() {
        String path = this.entry.getPath();
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    @Override
    public void indexesChanged(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        boolean refresh = false;
        String text = this.getText();
        for (Map.Entry entry : this.hyperlinks.entrySet()) {
            ManifestHyperlinkData entryData = (ManifestHyperlinkData)entry.getValue();
            String textLink = ManifestFilePage.getValue(text, entryData.startPosition, entryData.endPosition);
            String internalTypeName = textLink.replace('.', '/');
            boolean enabled = IndexesUtil.containsInternalTypeName(collectionOfFutureIndexes, internalTypeName);
            if (entryData.enabled == enabled) continue;
            entryData.enabled = enabled;
            refresh = true;
        }
        if (refresh) {
            this.textArea.repaint();
        }
    }

    public static String getValue(String text, int startPosition, int endPosition) {
        return text.substring(startPosition, endPosition).replace("\r\n ", "").replace("\r ", "").replace("\n ", "");
    }

    public static class ManifestHyperlinkData
    extends HyperlinkPage.HyperlinkData {
        public boolean enabled = false;
        public String fragment;

        ManifestHyperlinkData(int startPosition, int endPosition, String fragment) {
            super(startPosition, endPosition);
            this.fragment = fragment;
        }
    }
}

