/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.Dot11InformationElement;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Dot11InformationElementId;
import org.pcap4j.util.ByteArrays;

public final class Dot11MeshIdElement
extends Dot11InformationElement {
    private static final long serialVersionUID = 8808363321385383483L;
    private final byte[] meshId;

    public static Dot11MeshIdElement newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot11MeshIdElement(rawData, offset, length);
    }

    private Dot11MeshIdElement(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        super(rawData, offset, length, Dot11InformationElementId.MESH_ID);
        int infoLen = this.getLengthAsInt();
        this.meshId = infoLen == 0 ? new byte[0] : ByteArrays.getSubArray(rawData, offset + 2, infoLen);
    }

    private Dot11MeshIdElement(Builder builder2) {
        super(builder2);
        if (builder2.meshId.length > 255) {
            throw new IllegalArgumentException("Too long meshId: " + builder2.meshId);
        }
        this.meshId = ByteArrays.clone(builder2.meshId);
    }

    public byte[] getMeshId() {
        return ByteArrays.clone(this.meshId);
    }

    @Override
    public int length() {
        return 2 + this.meshId.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getElementId().value();
        rawData[1] = this.getLength();
        System.arraycopy(this.meshId, 0, rawData, 2, this.meshId.length);
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.meshId);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Dot11MeshIdElement other = (Dot11MeshIdElement)obj;
        return Arrays.equals(this.meshId, other.meshId);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Mesh ID:").append(ls);
        sb.append(indent).append("  Element ID: ").append(this.getElementId()).append(ls);
        sb.append(indent).append("  Length: ").append(this.getLengthAsInt()).append(" bytes").append(ls);
        sb.append(indent).append("  Mesh ID: ").append(new String(this.meshId)).append(" (0x").append(ByteArrays.toHexString(this.meshId, "")).append(")").append(ls);
        return sb.toString();
    }

    public static final class Builder
    extends Dot11InformationElement.Builder {
        private byte[] meshId;

        public Builder() {
            this.elementId(Dot11InformationElementId.getInstance((Byte)Dot11InformationElementId.MESH_ID.value()));
        }

        private Builder(Dot11MeshIdElement elem) {
            super(elem);
            this.meshId = elem.meshId;
        }

        public Builder meshId(byte[] meshId) {
            this.meshId = meshId;
            return this;
        }

        @Override
        public Builder length(byte length) {
            super.length(length);
            return this;
        }

        @Override
        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            super.correctLengthAtBuild(correctLengthAtBuild);
            return this;
        }

        @Override
        public Dot11MeshIdElement build() {
            if (this.meshId == null) {
                throw new NullPointerException("meshId is null.");
            }
            if (this.getCorrectLengthAtBuild()) {
                this.length((byte)this.meshId.length);
            }
            return new Dot11MeshIdElement(this);
        }
    }
}

