/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.PhotographicConversions;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.TagDescriptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public abstract class ExifDescriptorBase<T extends Directory>
extends TagDescriptor<T> {
    private final boolean _allowDecimalRepresentationOfRationals = true;

    public ExifDescriptorBase(@NotNull T directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 1: {
                return this.getInteropIndexDescription();
            }
            case 2: {
                return this.getInteropVersionDescription();
            }
            case 274: {
                return this.getOrientationDescription();
            }
            case 296: {
                return this.getResolutionDescription();
            }
            case 531: {
                return this.getYCbCrPositioningDescription();
            }
            case 282: {
                return this.getXResolutionDescription();
            }
            case 283: {
                return this.getYResolutionDescription();
            }
            case 256: {
                return this.getImageWidthDescription();
            }
            case 257: {
                return this.getImageHeightDescription();
            }
            case 258: {
                return this.getBitsPerSampleDescription();
            }
            case 262: {
                return this.getPhotometricInterpretationDescription();
            }
            case 278: {
                return this.getRowsPerStripDescription();
            }
            case 279: {
                return this.getStripByteCountsDescription();
            }
            case 277: {
                return this.getSamplesPerPixelDescription();
            }
            case 284: {
                return this.getPlanarConfigurationDescription();
            }
            case 530: {
                return this.getYCbCrSubsamplingDescription();
            }
            case 532: {
                return this.getReferenceBlackWhiteDescription();
            }
            case 40093: {
                return this.getWindowsAuthorDescription();
            }
            case 40092: {
                return this.getWindowsCommentDescription();
            }
            case 40094: {
                return this.getWindowsKeywordsDescription();
            }
            case 40095: {
                return this.getWindowsSubjectDescription();
            }
            case 40091: {
                return this.getWindowsTitleDescription();
            }
            case 254: {
                return this.getNewSubfileTypeDescription();
            }
            case 255: {
                return this.getSubfileTypeDescription();
            }
            case 263: {
                return this.getThresholdingDescription();
            }
            case 266: {
                return this.getFillOrderDescription();
            }
            case 33422: {
                return this.getCfaPattern2Description();
            }
            case 33434: {
                return this.getExposureTimeDescription();
            }
            case 37377: {
                return this.getShutterSpeedDescription();
            }
            case 33437: {
                return this.getFNumberDescription();
            }
            case 37122: {
                return this.getCompressedAverageBitsPerPixelDescription();
            }
            case 37382: {
                return this.getSubjectDistanceDescription();
            }
            case 37383: {
                return this.getMeteringModeDescription();
            }
            case 37384: {
                return this.getWhiteBalanceDescription();
            }
            case 37385: {
                return this.getFlashDescription();
            }
            case 37386: {
                return this.getFocalLengthDescription();
            }
            case 40961: {
                return this.getColorSpaceDescription();
            }
            case 40962: {
                return this.getExifImageWidthDescription();
            }
            case 40963: {
                return this.getExifImageHeightDescription();
            }
            case 41488: {
                return this.getFocalPlaneResolutionUnitDescription();
            }
            case 41486: {
                return this.getFocalPlaneXResolutionDescription();
            }
            case 41487: {
                return this.getFocalPlaneYResolutionDescription();
            }
            case 34850: {
                return this.getExposureProgramDescription();
            }
            case 37378: {
                return this.getApertureValueDescription();
            }
            case 37381: {
                return this.getMaxApertureValueDescription();
            }
            case 41495: {
                return this.getSensingMethodDescription();
            }
            case 37380: {
                return this.getExposureBiasDescription();
            }
            case 41728: {
                return this.getFileSourceDescription();
            }
            case 41729: {
                return this.getSceneTypeDescription();
            }
            case 41730: {
                return this.getCfaPatternDescription();
            }
            case 37121: {
                return this.getComponentConfigurationDescription();
            }
            case 36864: {
                return this.getExifVersionDescription();
            }
            case 40960: {
                return this.getFlashPixVersionDescription();
            }
            case 34855: {
                return this.getIsoEquivalentDescription();
            }
            case 37510: {
                return this.getUserCommentDescription();
            }
            case 41985: {
                return this.getCustomRenderedDescription();
            }
            case 41986: {
                return this.getExposureModeDescription();
            }
            case 41987: {
                return this.getWhiteBalanceModeDescription();
            }
            case 41988: {
                return this.getDigitalZoomRatioDescription();
            }
            case 41989: {
                return this.get35mmFilmEquivFocalLengthDescription();
            }
            case 41990: {
                return this.getSceneCaptureTypeDescription();
            }
            case 41991: {
                return this.getGainControlDescription();
            }
            case 41992: {
                return this.getContrastDescription();
            }
            case 41993: {
                return this.getSaturationDescription();
            }
            case 41994: {
                return this.getSharpnessDescription();
            }
            case 41996: {
                return this.getSubjectDistanceRangeDescription();
            }
            case 34864: {
                return this.getSensitivityTypeRangeDescription();
            }
            case 259: {
                return this.getCompressionDescription();
            }
            case 512: {
                return this.getJpegProcDescription();
            }
            case 42034: {
                return this.getLensSpecificationDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getInteropVersionDescription() {
        return this.getVersionBytesDescription(2, 2);
    }

    @Nullable
    public String getInteropIndexDescription() {
        String value = this._directory.getString(1);
        if (value == null) {
            return null;
        }
        return "R98".equalsIgnoreCase(value.trim()) ? "Recommended Exif Interoperability Rules (ExifR98)" : "Unknown (" + value + ")";
    }

    @Nullable
    public String getReferenceBlackWhiteDescription() {
        int[] ints = this._directory.getIntArray(532);
        if (ints == null || ints.length < 6) {
            Object o = this._directory.getObject(532);
            if (o != null && o instanceof long[]) {
                long[] longs = (long[])o;
                if (longs.length < 6) {
                    return null;
                }
                ints = new int[longs.length];
                for (int i = 0; i < longs.length; ++i) {
                    ints[i] = (int)longs[i];
                }
            } else {
                return null;
            }
        }
        int blackR = ints[0];
        int whiteR = ints[1];
        int blackG = ints[2];
        int whiteG = ints[3];
        int blackB = ints[4];
        int whiteB = ints[5];
        return String.format("[%d,%d,%d] [%d,%d,%d]", blackR, blackG, blackB, whiteR, whiteG, whiteB);
    }

    @Nullable
    public String getYResolutionDescription() {
        Rational value = this._directory.getRational(283);
        if (value == null) {
            return null;
        }
        String unit = this.getResolutionDescription();
        return String.format("%s dots per %s", value.toSimpleString(true), unit == null ? "unit" : unit.toLowerCase());
    }

    @Nullable
    public String getXResolutionDescription() {
        Rational value = this._directory.getRational(282);
        if (value == null) {
            return null;
        }
        String unit = this.getResolutionDescription();
        return String.format("%s dots per %s", value.toSimpleString(true), unit == null ? "unit" : unit.toLowerCase());
    }

    @Nullable
    public String getYCbCrPositioningDescription() {
        return this.getIndexedDescription(531, 1, "Center of pixel array", "Datum point");
    }

    @Nullable
    public String getOrientationDescription() {
        return super.getOrientationDescription(274);
    }

    @Nullable
    public String getResolutionDescription() {
        return this.getIndexedDescription(296, 1, "(No unit)", "Inch", "cm");
    }

    @Nullable
    private String getUnicodeDescription(int tag) {
        byte[] bytes = this._directory.getByteArray(tag);
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, "UTF-16LE").trim();
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    @Nullable
    public String getWindowsAuthorDescription() {
        return this.getUnicodeDescription(40093);
    }

    @Nullable
    public String getWindowsCommentDescription() {
        return this.getUnicodeDescription(40092);
    }

    @Nullable
    public String getWindowsKeywordsDescription() {
        return this.getUnicodeDescription(40094);
    }

    @Nullable
    public String getWindowsTitleDescription() {
        return this.getUnicodeDescription(40091);
    }

    @Nullable
    public String getWindowsSubjectDescription() {
        return this.getUnicodeDescription(40095);
    }

    @Nullable
    public String getYCbCrSubsamplingDescription() {
        int[] positions = this._directory.getIntArray(530);
        if (positions == null || positions.length < 2) {
            return null;
        }
        if (positions[0] == 2 && positions[1] == 1) {
            return "YCbCr4:2:2";
        }
        if (positions[0] == 2 && positions[1] == 2) {
            return "YCbCr4:2:0";
        }
        return "(Unknown)";
    }

    @Nullable
    public String getPlanarConfigurationDescription() {
        return this.getIndexedDescription(284, 1, "Chunky (contiguous for each subsampling pixel)", "Separate (Y-plane/Cb-plane/Cr-plane format)");
    }

    @Nullable
    public String getSamplesPerPixelDescription() {
        String value = this._directory.getString(277);
        return value == null ? null : value + " samples/pixel";
    }

    @Nullable
    public String getRowsPerStripDescription() {
        String value = this._directory.getString(278);
        return value == null ? null : value + " rows/strip";
    }

    @Nullable
    public String getStripByteCountsDescription() {
        String value = this._directory.getString(279);
        return value == null ? null : value + " bytes";
    }

    @Nullable
    public String getPhotometricInterpretationDescription() {
        Integer value = this._directory.getInteger(262);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "WhiteIsZero";
            }
            case 1: {
                return "BlackIsZero";
            }
            case 2: {
                return "RGB";
            }
            case 3: {
                return "RGB Palette";
            }
            case 4: {
                return "Transparency Mask";
            }
            case 5: {
                return "CMYK";
            }
            case 6: {
                return "YCbCr";
            }
            case 8: {
                return "CIELab";
            }
            case 9: {
                return "ICCLab";
            }
            case 10: {
                return "ITULab";
            }
            case 32803: {
                return "Color Filter Array";
            }
            case 32844: {
                return "Pixar LogL";
            }
            case 32845: {
                return "Pixar LogLuv";
            }
            case 32892: {
                return "Linear Raw";
            }
        }
        return "Unknown colour space";
    }

    @Nullable
    public String getBitsPerSampleDescription() {
        String value = this._directory.getString(258);
        return value == null ? null : value + " bits/component/pixel";
    }

    @Nullable
    public String getImageWidthDescription() {
        String value = this._directory.getString(256);
        return value == null ? null : value + " pixels";
    }

    @Nullable
    public String getImageHeightDescription() {
        String value = this._directory.getString(257);
        return value == null ? null : value + " pixels";
    }

    @Nullable
    public String getNewSubfileTypeDescription() {
        return this.getIndexedDescription(254, 0, "Full-resolution image", "Reduced-resolution image", "Single page of multi-page image", "Single page of multi-page reduced-resolution image", "Transparency mask", "Transparency mask of reduced-resolution image", "Transparency mask of multi-page image", "Transparency mask of reduced-resolution multi-page image");
    }

    @Nullable
    public String getSubfileTypeDescription() {
        return this.getIndexedDescription(255, 1, "Full-resolution image", "Reduced-resolution image", "Single page of multi-page image");
    }

    @Nullable
    public String getThresholdingDescription() {
        return this.getIndexedDescription(263, 1, "No dithering or halftoning", "Ordered dither or halftone", "Randomized dither");
    }

    @Nullable
    public String getFillOrderDescription() {
        return this.getIndexedDescription(266, 1, "Normal", "Reversed");
    }

    @Nullable
    public String getSubjectDistanceRangeDescription() {
        return this.getIndexedDescription(41996, "Unknown", "Macro", "Close view", "Distant view");
    }

    @Nullable
    public String getSensitivityTypeRangeDescription() {
        return this.getIndexedDescription(34864, "Unknown", "Standard Output Sensitivity", "Recommended Exposure Index", "ISO Speed", "Standard Output Sensitivity and Recommended Exposure Index", "Standard Output Sensitivity and ISO Speed", "Recommended Exposure Index and ISO Speed", "Standard Output Sensitivity, Recommended Exposure Index and ISO Speed");
    }

    @Nullable
    public String getLensSpecificationDescription() {
        return this.getLensSpecificationDescription(42034);
    }

    @Nullable
    public String getSharpnessDescription() {
        return this.getIndexedDescription(41994, "None", "Low", "Hard");
    }

    @Nullable
    public String getSaturationDescription() {
        return this.getIndexedDescription(41993, "None", "Low saturation", "High saturation");
    }

    @Nullable
    public String getContrastDescription() {
        return this.getIndexedDescription(41992, "None", "Soft", "Hard");
    }

    @Nullable
    public String getGainControlDescription() {
        return this.getIndexedDescription(41991, "None", "Low gain up", "Low gain down", "High gain up", "High gain down");
    }

    @Nullable
    public String getSceneCaptureTypeDescription() {
        return this.getIndexedDescription(41990, "Standard", "Landscape", "Portrait", "Night scene");
    }

    @Nullable
    public String get35mmFilmEquivFocalLengthDescription() {
        Integer value = this._directory.getInteger(41989);
        return value == null ? null : (value == 0 ? "Unknown" : ExifDescriptorBase.getFocalLengthDescription(value.intValue()));
    }

    @Nullable
    public String getDigitalZoomRatioDescription() {
        Rational value = this._directory.getRational(41988);
        return value == null ? null : (value.getNumerator() == 0L ? "Digital zoom not used" : new DecimalFormat("0.#").format(value.doubleValue()));
    }

    @Nullable
    public String getWhiteBalanceModeDescription() {
        return this.getIndexedDescription(41987, "Auto white balance", "Manual white balance");
    }

    @Nullable
    public String getExposureModeDescription() {
        return this.getIndexedDescription(41986, "Auto exposure", "Manual exposure", "Auto bracket");
    }

    @Nullable
    public String getCustomRenderedDescription() {
        return this.getIndexedDescription(41985, "Normal process", "Custom process");
    }

    @Nullable
    public String getUserCommentDescription() {
        byte[] commentBytes = this._directory.getByteArray(37510);
        if (commentBytes == null) {
            return null;
        }
        if (commentBytes.length == 0) {
            return "";
        }
        HashMap<String, String> encodingMap = new HashMap<String, String>();
        encodingMap.put("ASCII", System.getProperty("file.encoding"));
        encodingMap.put("UNICODE", "UTF-16LE");
        encodingMap.put("JIS", "Shift-JIS");
        try {
            if (commentBytes.length >= 10) {
                String firstTenBytesString = new String(commentBytes, 0, 10);
                for (Map.Entry pair : encodingMap.entrySet()) {
                    String encodingName = (String)pair.getKey();
                    String charset = (String)pair.getValue();
                    if (!firstTenBytesString.startsWith(encodingName)) continue;
                    for (int j = encodingName.length(); j < 10; ++j) {
                        byte b = commentBytes[j];
                        if (b == 0 || b == 32) continue;
                        return new String(commentBytes, j, commentBytes.length - j, charset).trim();
                    }
                    return new String(commentBytes, 10, commentBytes.length - 10, charset).trim();
                }
            }
            return new String(commentBytes, System.getProperty("file.encoding")).trim();
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    @Nullable
    public String getIsoEquivalentDescription() {
        Integer isoEquiv = this._directory.getInteger(34855);
        return isoEquiv != null ? Integer.toString(isoEquiv) : null;
    }

    @Nullable
    public String getExifVersionDescription() {
        return this.getVersionBytesDescription(36864, 2);
    }

    @Nullable
    public String getFlashPixVersionDescription() {
        return this.getVersionBytesDescription(40960, 2);
    }

    @Nullable
    public String getSceneTypeDescription() {
        return this.getIndexedDescription(41729, 1, "Directly photographed image");
    }

    @Nullable
    public String getCfaPatternDescription() {
        return ExifDescriptorBase.formatCFAPattern(this.decodeCfaPattern(41730));
    }

    @Nullable
    public String getCfaPattern2Description() {
        byte[] values = this._directory.getByteArray(33422);
        if (values == null) {
            return null;
        }
        int[] repeatPattern = this._directory.getIntArray(33421);
        if (repeatPattern == null) {
            return String.format("Repeat Pattern not found for CFAPattern (%s)", super.getDescription(33422));
        }
        if (repeatPattern.length == 2 && values.length == repeatPattern[0] * repeatPattern[1]) {
            int[] intpattern = new int[2 + values.length];
            intpattern[0] = repeatPattern[0];
            intpattern[1] = repeatPattern[1];
            for (int i = 0; i < values.length; ++i) {
                intpattern[i + 2] = values[i] & 0xFF;
            }
            return ExifDescriptorBase.formatCFAPattern(intpattern);
        }
        return String.format("Unknown Pattern (%s)", super.getDescription(33422));
    }

    @Nullable
    private static String formatCFAPattern(@Nullable int[] pattern) {
        if (pattern == null) {
            return null;
        }
        if (pattern.length < 2) {
            return "<truncated data>";
        }
        if (pattern[0] == 0 && pattern[1] == 0) {
            return "<zero pattern size>";
        }
        int end = 2 + pattern[0] * pattern[1];
        if (end > pattern.length) {
            return "<invalid pattern size>";
        }
        String[] cfaColors = new String[]{"Red", "Green", "Blue", "Cyan", "Magenta", "Yellow", "White"};
        StringBuilder ret = new StringBuilder();
        ret.append("[");
        for (int pos = 2; pos < end; ++pos) {
            if (pattern[pos] <= cfaColors.length - 1) {
                ret.append(cfaColors[pattern[pos]]);
            } else {
                ret.append("Unknown");
            }
            if ((pos - 2) % pattern[1] == 0) {
                ret.append(",");
                continue;
            }
            if (pos == end - 1) continue;
            ret.append("][");
        }
        ret.append("]");
        return ret.toString();
    }

    @Nullable
    private int[] decodeCfaPattern(int tagType) {
        byte[] values = this._directory.getByteArray(tagType);
        if (values == null) {
            return null;
        }
        if (values.length < 4) {
            int[] ret = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        int[] ret = new int[values.length - 2];
        try {
            ByteArrayReader reader = new ByteArrayReader(values);
            short item0 = reader.getInt16(0);
            short item1 = reader.getInt16(2);
            Boolean copyArray = false;
            int end = 2 + item0 * item1;
            if (end > values.length) {
                reader.setMotorolaByteOrder(!reader.isMotorolaByteOrder());
                item0 = reader.getInt16(0);
                item1 = reader.getInt16(2);
                if (values.length >= 2 + item0 * item1) {
                    copyArray = true;
                }
            } else {
                copyArray = true;
            }
            if (copyArray.booleanValue()) {
                ret[0] = item0;
                ret[1] = item1;
                for (int i = 4; i < values.length; ++i) {
                    ret[i - 2] = reader.getInt8(i);
                }
            }
        }
        catch (IOException ex) {
            this._directory.addError("IO exception processing data: " + ex.getMessage());
        }
        return ret;
    }

    @Nullable
    public String getFileSourceDescription() {
        return this.getIndexedDescription(41728, 1, "Film Scanner", "Reflection Print Scanner", "Digital Still Camera (DSC)");
    }

    @Nullable
    public String getExposureBiasDescription() {
        Rational value = this._directory.getRational(37380);
        if (value == null) {
            return null;
        }
        return value.toSimpleString(true) + " EV";
    }

    @Nullable
    public String getMaxApertureValueDescription() {
        Double aperture = this._directory.getDoubleObject(37381);
        if (aperture == null) {
            return null;
        }
        double fStop = PhotographicConversions.apertureToFStop(aperture);
        return ExifDescriptorBase.getFStopDescription(fStop);
    }

    @Nullable
    public String getApertureValueDescription() {
        Double aperture = this._directory.getDoubleObject(37378);
        if (aperture == null) {
            return null;
        }
        double fStop = PhotographicConversions.apertureToFStop(aperture);
        return ExifDescriptorBase.getFStopDescription(fStop);
    }

    @Nullable
    public String getExposureProgramDescription() {
        return this.getIndexedDescription(34850, 1, "Manual control", "Program normal", "Aperture priority", "Shutter priority", "Program creative (slow program)", "Program action (high-speed program)", "Portrait mode", "Landscape mode");
    }

    @Nullable
    public String getFocalPlaneXResolutionDescription() {
        Rational rational = this._directory.getRational(41486);
        if (rational == null) {
            return null;
        }
        String unit = this.getFocalPlaneResolutionUnitDescription();
        return rational.getReciprocal().toSimpleString(true) + (unit == null ? "" : " " + unit.toLowerCase());
    }

    @Nullable
    public String getFocalPlaneYResolutionDescription() {
        Rational rational = this._directory.getRational(41487);
        if (rational == null) {
            return null;
        }
        String unit = this.getFocalPlaneResolutionUnitDescription();
        return rational.getReciprocal().toSimpleString(true) + (unit == null ? "" : " " + unit.toLowerCase());
    }

    @Nullable
    public String getFocalPlaneResolutionUnitDescription() {
        return this.getIndexedDescription(41488, 1, "(No unit)", "Inches", "cm");
    }

    @Nullable
    public String getExifImageWidthDescription() {
        Integer value = this._directory.getInteger(40962);
        return value == null ? null : value + " pixels";
    }

    @Nullable
    public String getExifImageHeightDescription() {
        Integer value = this._directory.getInteger(40963);
        return value == null ? null : value + " pixels";
    }

    @Nullable
    public String getColorSpaceDescription() {
        Integer value = this._directory.getInteger(40961);
        if (value == null) {
            return null;
        }
        if (value == 1) {
            return "sRGB";
        }
        if (value == 65535) {
            return "Undefined";
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFocalLengthDescription() {
        Rational value = this._directory.getRational(37386);
        return value == null ? null : ExifDescriptorBase.getFocalLengthDescription(value.doubleValue());
    }

    @Nullable
    public String getFlashDescription() {
        Integer value = this._directory.getInteger(37385);
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if ((value & 1) != 0) {
            sb.append("Flash fired");
        } else {
            sb.append("Flash did not fire");
        }
        if ((value & 4) != 0) {
            if ((value & 2) != 0) {
                sb.append(", return detected");
            } else {
                sb.append(", return not detected");
            }
        }
        if ((value & 0x10) != 0) {
            sb.append(", auto");
        }
        if ((value & 0x40) != 0) {
            sb.append(", red-eye reduction");
        }
        return sb.toString();
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer value = this._directory.getInteger(37384);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Daylight";
            }
            case 2: {
                return "Florescent";
            }
            case 3: {
                return "Tungsten";
            }
            case 4: {
                return "Flash";
            }
            case 9: {
                return "Fine Weather";
            }
            case 10: {
                return "Cloudy";
            }
            case 11: {
                return "Shade";
            }
            case 12: {
                return "Daylight Fluorescent";
            }
            case 13: {
                return "Day White Fluorescent";
            }
            case 14: {
                return "Cool White Fluorescent";
            }
            case 15: {
                return "White Fluorescent";
            }
            case 16: {
                return "Warm White Fluorescent";
            }
            case 17: {
                return "Standard light";
            }
            case 18: {
                return "Standard light (B)";
            }
            case 19: {
                return "Standard light (C)";
            }
            case 20: {
                return "D55";
            }
            case 21: {
                return "D65";
            }
            case 22: {
                return "D75";
            }
            case 23: {
                return "D50";
            }
            case 24: {
                return "Studio Tungsten";
            }
            case 255: {
                return "(Other)";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getMeteringModeDescription() {
        Integer value = this._directory.getInteger(37383);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Average";
            }
            case 2: {
                return "Center weighted average";
            }
            case 3: {
                return "Spot";
            }
            case 4: {
                return "Multi-spot";
            }
            case 5: {
                return "Multi-segment";
            }
            case 6: {
                return "Partial";
            }
            case 255: {
                return "(Other)";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getCompressionDescription() {
        Integer value = this._directory.getInteger(259);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Uncompressed";
            }
            case 2: {
                return "CCITT 1D";
            }
            case 3: {
                return "T4/Group 3 Fax";
            }
            case 4: {
                return "T6/Group 4 Fax";
            }
            case 5: {
                return "LZW";
            }
            case 6: {
                return "JPEG (old-style)";
            }
            case 7: {
                return "JPEG";
            }
            case 8: {
                return "Adobe Deflate";
            }
            case 9: {
                return "JBIG B&W";
            }
            case 10: {
                return "JBIG Color";
            }
            case 99: {
                return "JPEG";
            }
            case 262: {
                return "Kodak 262";
            }
            case 32766: {
                return "Next";
            }
            case 32767: {
                return "Sony ARW Compressed";
            }
            case 32769: {
                return "Packed RAW";
            }
            case 32770: {
                return "Samsung SRW Compressed";
            }
            case 32771: {
                return "CCIRLEW";
            }
            case 32772: {
                return "Samsung SRW Compressed 2";
            }
            case 32773: {
                return "PackBits";
            }
            case 32809: {
                return "Thunderscan";
            }
            case 32867: {
                return "Kodak KDC Compressed";
            }
            case 32895: {
                return "IT8CTPAD";
            }
            case 32896: {
                return "IT8LW";
            }
            case 32897: {
                return "IT8MP";
            }
            case 32898: {
                return "IT8BL";
            }
            case 32908: {
                return "PixarFilm";
            }
            case 32909: {
                return "PixarLog";
            }
            case 32946: {
                return "Deflate";
            }
            case 32947: {
                return "DCS";
            }
            case 34661: {
                return "JBIG";
            }
            case 34676: {
                return "SGILog";
            }
            case 34677: {
                return "SGILog24";
            }
            case 34712: {
                return "JPEG 2000";
            }
            case 34713: {
                return "Nikon NEF Compressed";
            }
            case 34715: {
                return "JBIG2 TIFF FX";
            }
            case 34718: {
                return "Microsoft Document Imaging (MDI) Binary Level Codec";
            }
            case 34719: {
                return "Microsoft Document Imaging (MDI) Progressive Transform Codec";
            }
            case 34720: {
                return "Microsoft Document Imaging (MDI) Vector";
            }
            case 34892: {
                return "Lossy JPEG";
            }
            case 65000: {
                return "Kodak DCR Compressed";
            }
            case 65535: {
                return "Pentax PEF Compressed";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSubjectDistanceDescription() {
        Rational value = this._directory.getRational(37382);
        if (value == null) {
            return null;
        }
        DecimalFormat formatter = new DecimalFormat("0.0##");
        return formatter.format(value.doubleValue()) + " metres";
    }

    @Nullable
    public String getCompressedAverageBitsPerPixelDescription() {
        Rational value = this._directory.getRational(37122);
        if (value == null) {
            return null;
        }
        String ratio = value.toSimpleString(true);
        return value.isInteger() && value.intValue() == 1 ? ratio + " bit/pixel" : ratio + " bits/pixel";
    }

    @Nullable
    public String getExposureTimeDescription() {
        String value = this._directory.getString(33434);
        return value == null ? null : value + " sec";
    }

    @Nullable
    public String getShutterSpeedDescription() {
        return super.getShutterSpeedDescription(37377);
    }

    @Nullable
    public String getFNumberDescription() {
        Rational value = this._directory.getRational(33437);
        if (value == null) {
            return null;
        }
        return ExifDescriptorBase.getFStopDescription(value.doubleValue());
    }

    @Nullable
    public String getSensingMethodDescription() {
        return this.getIndexedDescription(41495, 1, "(Not defined)", "One-chip color area sensor", "Two-chip color area sensor", "Three-chip color area sensor", "Color sequential area sensor", null, "Trilinear sensor", "Color sequential linear sensor");
    }

    @Nullable
    public String getComponentConfigurationDescription() {
        int[] components = this._directory.getIntArray(37121);
        if (components == null) {
            return null;
        }
        String[] componentStrings = new String[]{"", "Y", "Cb", "Cr", "R", "G", "B"};
        StringBuilder componentConfig = new StringBuilder();
        for (int i = 0; i < Math.min(4, components.length); ++i) {
            int j = components[i];
            if (j <= 0 || j >= componentStrings.length) continue;
            componentConfig.append(componentStrings[j]);
        }
        return componentConfig.toString();
    }

    @Nullable
    public String getJpegProcDescription() {
        Integer value = this._directory.getInteger(512);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Baseline";
            }
            case 14: {
                return "Lossless";
            }
        }
        return "Unknown (" + value + ")";
    }
}

