/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Graphics2D;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.MapViewGraphics;

@FunctionalInterface
public interface MapViewPaintable {
    public void paint(Graphics2D var1, MapView var2, Bounds var3);

    default public void addInvalidationListener(PaintableInvalidationListener l) {
    }

    default public void removeInvalidationListener(PaintableInvalidationListener l) {
    }

    public static class MapViewEvent {
        private final MapView mapView;
        private final boolean temporaryLayer;

        public MapViewEvent(MapView mapView, boolean temporaryLayer) {
            this.mapView = mapView;
            this.temporaryLayer = temporaryLayer;
        }

        public MapView getMapView() {
            return this.mapView;
        }

        public boolean isTemporaryLayer() {
            return this.temporaryLayer;
        }

        public String toString() {
            return "AttachToMapViewEvent [mapView=" + this.mapView + ", temporaryLayer=" + this.temporaryLayer + "]";
        }
    }

    public static interface LayerPainter {
        public void paint(MapViewGraphics var1);

        public void detachFromMapView(MapViewEvent var1);
    }

    @FunctionalInterface
    public static interface PaintableInvalidationListener {
        public void paintableInvalidated(PaintableInvalidationEvent var1);
    }

    public static class PaintableInvalidationEvent {
        private final MapViewPaintable paintable;

        public PaintableInvalidationEvent(MapViewPaintable paintable) {
            this.paintable = paintable;
        }

        public MapViewPaintable getLayer() {
            return this.paintable;
        }

        public String toString() {
            return "LayerInvalidationEvent [layer=" + this.paintable + ']';
        }
    }
}

