/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.viewer.tableviewer;

import com.ca.commons.cbutil.CBIntText;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class AttributeValueCellRenderer
extends DefaultTableCellRenderer {
    Font normalFont = this.getFont();
    Font boldFont = this.normalFont.deriveFont(1);
    Font boldBlueFont = this.normalFont.deriveFont(1);

    protected void setValue(Object value) {
        if (value instanceof AttributeValue) {
            if (((AttributeValue)value).isBinary() && !((AttributeValue)value).isEmpty()) {
                value = CBIntText.get("(non string data)");
            } else {
                String stringVal = value.toString();
                if (stringVal.length() > 100) {
                    value = this.truncateLongString(stringVal);
                }
                if (stringVal.substring(0, 6).toLowerCase().startsWith("<html>")) {
                    value = " " + stringVal;
                }
            }
        }
        super.setValue(value);
    }

    public String truncateLongString(String truncateMe) {
        return truncateMe.substring(0, 100) + "...";
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof AttributeValue) {
            AttributeValue attVal = (AttributeValue)value;
            String attString = attVal.toString();
            if (attString.length() > 100) {
                attString = this.truncateLongString(attString);
            }
            Component c = super.getTableCellRendererComponent(table, attString, isSelected, hasFocus, row, column);
            if (attVal.isNaming()) {
                c.setForeground(isSelected ? Color.white : Color.blue);
                c.setFont(this.boldFont);
            } else {
                c.setForeground(isSelected ? Color.white : Color.black);
                c.setFont(this.normalFont);
            }
            return c;
        }
        return super.getTableCellRendererComponent(table, new String("error"), isSelected, hasFocus, row, column);
    }
}

