/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class UUIDUtil {
    private UUIDUtil() {
    }

    @NotNull
    public static UUID fromString(@NotNull String value) {
        return UUID.fromString(value);
    }

    @NotNull
    public static byte[] convertUUIDToBytes(@NotNull UUID uuid) {
        long hi = uuid.getMostSignificantBits();
        long lo = uuid.getLeastSignificantBits();
        return ByteBuffer.allocate(16).putLong(hi).putLong(lo).array();
    }

    @NotNull
    public static UUID fromBytes(@NotNull byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        long hi = bb.getLong();
        long lo = bb.getLong();
        return new UUID(hi, lo);
    }
}

