/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier.internal.asn1;

import com.webauthn4j.util.UnsignedNumberUtil;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ASN1Tag {
    public static final int ANY = 0;
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int BIT_STRING = 3;
    public static final int OCTET_STRING = 4;
    public static final int NULL = 5;
    public static final int OBJECT_IDENTIFIER = 6;
    public static final int REAL = 9;
    public static final int ENUMERATED = 10;
    public static final int UTF8_STRING = 12;
    public static final int SEQUENCE = 16;
    public static final int SET = 17;
    public static final int NUMERIC_STRING = 18;
    public static final int PRINTABLE_STRING = 19;
    public static final int VIDEOTEX_STRING = 21;
    public static final int IA5_STRING = 22;
    public static final int UTC_TIME = 23;
    public static final int GRAPHIC_STRING = 25;
    public static final int ISO646_STRING = 26;
    public static final int GENERAL_STRING = 27;
    public static final int UNIVERSAL_STRING = 28;
    public static final int BMP_STRING = 30;
    public static final int CONTEXT_SPECIFIC = 128;
    private static final int CLASS_MASK = 192;
    private static final int CONSTRUCTED_MASK = 32;
    private static final int NUMBER_MASK = 31;
    private static final int LEADING_BIT_MASK = 128;
    private final ASN1TagClass tagClass;
    private final boolean constructed;
    private final int number;

    public static ASN1Tag parse(ByteBuffer byteBuffer) {
        byte byteValue = byteBuffer.get();
        ASN1TagClass tagClass = ASN1TagClass.from(byteValue);
        short unsignedByteValue = UnsignedNumberUtil.getUnsignedByte(byteValue);
        boolean tagConstructed = (unsignedByteValue & 0x20) > 0;
        int tagNumber = 0;
        if ((unsignedByteValue & 0x1F) != 31) {
            tagNumber = unsignedByteValue & 0x1F;
        } else {
            short octet;
            do {
                octet = UnsignedNumberUtil.getUnsignedByte(byteBuffer.get());
                tagNumber = tagNumber * 128 + (octet & 0xFFFFFF7F);
            } while ((octet & 0x80) != 0);
        }
        return new ASN1Tag(tagClass, tagConstructed, tagNumber);
    }

    ASN1Tag(ASN1TagClass tagClass, boolean constructed, int number) {
        this.tagClass = tagClass;
        this.constructed = constructed;
        this.number = number;
    }

    public ASN1TagClass getTagClass() {
        return this.tagClass;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ASN1Tag asn1Tag = (ASN1Tag)o;
        return this.constructed == asn1Tag.constructed && this.number == asn1Tag.number && this.tagClass == asn1Tag.tagClass;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tagClass, this.constructed, this.number});
    }

    public static enum ASN1TagClass {
        UNIVERSAL(0),
        APPLICATION(64),
        CONTEXT_SPECIFIC(-128),
        PRIVATE(-64);

        private final byte value;

        private ASN1TagClass(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static ASN1TagClass from(byte value) {
            byte classBits = (byte)(value & 0xC0);
            for (ASN1TagClass tagClass : ASN1TagClass.values()) {
                if (classBits != tagClass.getValue()) continue;
                return tagClass;
            }
            throw new IllegalArgumentException("Invalid tag class value: " + Integer.toBinaryString(value));
        }
    }
}

