/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.forms;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jboss.logging.Logger;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.authentication.forms.AbstractRegistrationRecaptcha;
import org.keycloak.authentication.forms.RecaptchaAssessmentRequest;
import org.keycloak.authentication.forms.RecaptchaAssessmentResponse;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.services.ServicesLogger;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.StringUtil;

public class RegistrationRecaptchaEnterprise
extends AbstractRegistrationRecaptcha {
    public static final String PROVIDER_ID = "registration-recaptcha-enterprise";
    public static final String PROJECT_ID = "project.id";
    public static final String API_KEY = "api.key";
    public static final String SCORE_THRESHOLD = "score.threshold";
    private static final Logger LOGGER = Logger.getLogger(RegistrationRecaptchaEnterprise.class);

    public String getDisplayType() {
        return "reCAPTCHA Enterprise";
    }

    public String getHelpText() {
        return "Adds Google reCAPTCHA Enterprise to the form.";
    }

    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    protected boolean validateConfig(Map<String, String> config) {
        return !Stream.of(PROJECT_ID, "site.key", API_KEY, "action").anyMatch(key -> StringUtil.isNullOrEmpty((String)((String)config.get(key)))) && this.parseDoubleFromConfig(config, SCORE_THRESHOLD) != null;
    }

    @Override
    protected String getScriptUrl(Map<String, String> config, String userLanguageTag) {
        return "https://www." + this.getRecaptchaDomain(config) + "/recaptcha/enterprise.js?hl=" + userLanguageTag;
    }

    @Override
    protected boolean validate(ValidationContext context, String captcha, Map<String, String> config) {
        LOGGER.trace((Object)"Requesting assessment of Google reCAPTCHA Enterprise");
        try {
            HttpPost request = this.buildAssessmentRequest(captcha, config);
            CloseableHttpClient httpClient = ((HttpClientProvider)context.getSession().getProvider(HttpClientProvider.class)).getHttpClient();
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                LOGGER.errorf("Could not create reCAPTCHA assessment: %s", (Object)response.getStatusLine());
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                throw new Exception(response.getStatusLine().getReasonPhrase());
            }
            RecaptchaAssessmentResponse assessment = (RecaptchaAssessmentResponse)JsonSerialization.readValue((InputStream)response.getEntity().getContent(), RecaptchaAssessmentResponse.class);
            LOGGER.tracef("Got assessment response: %s", (Object)assessment);
            String tokenAction = assessment.getTokenProperties().getAction();
            String expectedAction = assessment.getEvent().getExpectedAction();
            if (!tokenAction.equals(expectedAction)) {
                LOGGER.warnf("The action name of the reCAPTCHA token '%s' does not match the expected action '%s'!", (Object)tokenAction, (Object)expectedAction);
                return false;
            }
            boolean valid = assessment.getTokenProperties().isValid();
            double score = assessment.getRiskAnalysis().getScore();
            LOGGER.debugf("reCAPTCHA assessment: valid=%s, score=%f", (Object)valid, (Object)score);
            return valid && score >= this.parseDoubleFromConfig(config, SCORE_THRESHOLD);
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.recaptchaFailed(e);
            return false;
        }
    }

    private HttpPost buildAssessmentRequest(String captcha, Map<String, String> config) throws IOException {
        String url = String.format("https://recaptchaenterprise.googleapis.com/v1/projects/%s/assessments?key=%s", config.get(PROJECT_ID), config.get(API_KEY));
        HttpPost request = new HttpPost(url);
        RecaptchaAssessmentRequest body = new RecaptchaAssessmentRequest(captcha, config.get("site.key"), config.get("action"));
        request.setEntity((HttpEntity)new StringEntity(JsonSerialization.writeValueAsString((Object)body)));
        request.setHeader("Content-type", "application/json; charset=utf-8");
        LOGGER.tracef("Built assessment request: %s", (Object)body);
        return request;
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        List properties = ProviderConfigurationBuilder.create().property().name(PROJECT_ID).label("Project ID").helpText("Project ID the site key belongs to.").type("String").add().property().name("site.key").label("reCAPTCHA Site Key").helpText("The site key.").type("String").add().property().name(API_KEY).label("Google API Key").helpText("An API key with the reCAPTCHA Enterprise API enabled in the given project ID.").type("String").secret(true).add().property().name(SCORE_THRESHOLD).label("Min. Score Threshold").helpText("The minimum score threshold for considering the reCAPTCHA valid (inclusive). Must be a valid double between 0.0 and 1.0.").type("String").defaultValue((Object)"0.7").add().build();
        properties.addAll(super.getConfigProperties());
        return properties;
    }

    private Double parseDoubleFromConfig(Map<String, String> config, String key) {
        String value = config.getOrDefault(key, "");
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            LOGGER.warnf("Could not parse config %s as double: '%s'", (Object)key, (Object)value);
            return null;
        }
    }
}

