/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.BruteForceProtectorFactory;
import org.keycloak.services.managers.DefaultBlockingBruteForceProtector;
import org.keycloak.services.managers.DefaultBruteForceProtector;

public class DefaultBruteForceProtectorFactory
implements BruteForceProtectorFactory {
    DefaultBruteForceProtector protector;
    private boolean allowConcurrentRequests;

    public BruteForceProtector create(KeycloakSession session) {
        return this.protector;
    }

    public void init(Config.Scope config) {
        this.allowConcurrentRequests = config.getBoolean("allowConcurrentRequests", Boolean.FALSE);
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.protector = this.allowConcurrentRequests ? new DefaultBruteForceProtector(factory) : new DefaultBlockingBruteForceProtector(factory);
    }

    public void close() {
        this.protector.shutdown();
    }

    public String getId() {
        return "default-brute-force-detector";
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("allowConcurrentRequests").type("boolean").helpText("If concurrent logins are allowed by the brute force protection.").defaultValue((Object)false).add().build();
    }
}

