/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.partitionhandling.AvailabilityMode;

public class CacheAvailabilityUpdateCommand
extends AbstractCacheControlCommand {
    public static final byte COMMAND_ID = 98;
    private String cacheName;
    private AvailabilityMode availabilityMode;

    public CacheAvailabilityUpdateCommand() {
        super((byte)98);
    }

    public CacheAvailabilityUpdateCommand(String cacheName, AvailabilityMode availabilityMode) {
        super((byte)98);
        this.cacheName = cacheName;
        this.availabilityMode = availabilityMode;
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        return gcr.getClusterTopologyManager().forceAvailabilityMode(this.cacheName, this.availabilityMode);
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallString((String)this.cacheName, (ObjectOutput)output);
        MarshallUtil.marshallEnum((Enum)this.availabilityMode, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.cacheName = MarshallUtil.unmarshallString((ObjectInput)input);
        this.availabilityMode = (AvailabilityMode)MarshallUtil.unmarshallEnum((ObjectInput)input, AvailabilityMode::valueOf);
    }

    public String toString() {
        return "UpdateAvailabilityCommand{cacheName='" + this.cacheName + "', availabilityMode=" + String.valueOf((Object)this.availabilityMode) + "}";
    }
}

