/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.PendingLockManager;
import org.infinispan.util.concurrent.locks.impl.DefaultLockManager;
import org.infinispan.util.concurrent.locks.impl.DefaultPendingLockManager;
import org.infinispan.util.concurrent.locks.impl.NoOpPendingLockManager;
import org.infinispan.util.logging.Log;

@DefaultFactoryFor(classes={LockManager.class, PendingLockManager.class})
public class LockManagerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public Object construct(String componentName) {
        if (PendingLockManager.class.getName().equals(componentName)) {
            return this.configuration.clustering().cacheMode().isClustered() ? new DefaultPendingLockManager() : NoOpPendingLockManager.getInstance();
        }
        if (LockManager.class.getName().equals(componentName)) {
            return new DefaultLockManager();
        }
        throw Log.CONTAINER.factoryCannotConstructComponent(componentName);
    }
}

