/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.quarkus.jackson.ObjectMapperCustomizer;
import io.quarkus.resteasy.reactive.jackson.runtime.ResteasyReactiveServerJacksonRecorder;
import jakarta.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

@Singleton
public class GeneratedSerializersRegister
implements ObjectMapperCustomizer {
    public void customize(ObjectMapper objectMapper) {
        objectMapper.registerModule(MappingModuleHolder.mappingModule);
    }

    static class MappingModuleHolder {
        static final Module mappingModule = MappingModuleHolder.createMappingModule();

        MappingModuleHolder() {
        }

        private static Module createMappingModule() {
            SimpleModule module = new SimpleModule();
            ExactSerializers serializers = new ExactSerializers();
            for (Class<? extends StdSerializer> clazz : ResteasyReactiveServerJacksonRecorder.getGeneratedSerializers()) {
                try {
                    StdSerializer serializer = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    serializers.addExactSerializer(serializer.handledType(), serializer);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            module.setSerializers((SimpleSerializers)serializers);
            for (Class<? extends StdSerializer> clazz : ResteasyReactiveServerJacksonRecorder.getGeneratedDeserializers()) {
                try {
                    StdDeserializer deserializer = (StdDeserializer)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    module.addDeserializer(deserializer.handledType(), (JsonDeserializer)deserializer);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return module;
        }
    }

    public static class ExactSerializers
    extends SimpleSerializers {
        private final Map<Class<?>, JsonSerializer<?>> exactSerializers = new HashMap();

        public <T> void addExactSerializer(Class<? extends T> type, JsonSerializer<T> ser) {
            this.exactSerializers.put(type, ser);
        }

        public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
            JsonSerializer exactSerializer = this.exactSerializers.get(type.getRawClass());
            return exactSerializer != null ? exactSerializer : super.findSerializer(config, type, beanDesc);
        }
    }
}

