/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import jakarta.persistence.TypedQuery;

public class PaginationUtils {
    public static final int DEFAULT_MAX_RESULTS = 0x3FFFFFFF;

    public static <T> TypedQuery<T> paginateQuery(TypedQuery<T> query, Integer first, Integer max) {
        if (first != null && first >= 0) {
            query = query.setFirstResult(first.intValue());
            if (max == null || max < 0) {
                max = 0x3FFFFFFF;
            }
        }
        if (max != null && max >= 0) {
            query = query.setMaxResults(max.intValue());
        }
        return query;
    }
}

