/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.annotations.TimeZoneStorage;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.internal.OffsetDateTimeCompositeUserType;
import org.hibernate.usertype.internal.OffsetTimeCompositeUserType;
import org.hibernate.usertype.internal.ZonedDateTimeCompositeUserType;

public class TimeZoneStorageHelper {
    private static final String OFFSET_TIME_CLASS = OffsetTime.class.getName();
    private static final String OFFSET_DATETIME_CLASS = OffsetDateTime.class.getName();
    private static final String ZONED_DATETIME_CLASS = ZonedDateTime.class.getName();

    static Class<? extends CompositeUserType<?>> resolveTimeZoneStorageCompositeUserType(XProperty property, XClass returnedClass, MetadataBuildingContext context) {
        if (TimeZoneStorageHelper.useColumnForTimeZoneStorage((XAnnotatedElement)property, context)) {
            String returnedClassName = returnedClass.getName();
            if (OFFSET_DATETIME_CLASS.equals(returnedClassName)) {
                return OffsetDateTimeCompositeUserType.class;
            }
            if (ZONED_DATETIME_CLASS.equals(returnedClassName)) {
                return ZonedDateTimeCompositeUserType.class;
            }
            if (OFFSET_TIME_CLASS.equals(returnedClassName)) {
                return OffsetTimeCompositeUserType.class;
            }
        }
        return null;
    }

    private static boolean isTemporalWithTimeZoneClass(String returnedClassName) {
        return OFFSET_DATETIME_CLASS.equals(returnedClassName) || ZONED_DATETIME_CLASS.equals(returnedClassName) || TimeZoneStorageHelper.isOffsetTimeClass(returnedClassName);
    }

    public static boolean isOffsetTimeClass(XAnnotatedElement element) {
        if (element instanceof XProperty) {
            XProperty property = (XProperty)element;
            return TimeZoneStorageHelper.isOffsetTimeClass(property.getType().getName());
        }
        return false;
    }

    private static boolean isOffsetTimeClass(String returnedClassName) {
        return OFFSET_TIME_CLASS.equals(returnedClassName);
    }

    static boolean useColumnForTimeZoneStorage(XAnnotatedElement element, MetadataBuildingContext context) {
        TimeZoneStorage timeZoneStorage = (TimeZoneStorage)element.getAnnotation(TimeZoneStorage.class);
        if (timeZoneStorage == null) {
            if (element instanceof XProperty) {
                XProperty property = (XProperty)element;
                return TimeZoneStorageHelper.isTemporalWithTimeZoneClass(property.getType().getName()) && context.getBuildingOptions().getDefaultTimeZoneStorage() == TimeZoneStorageStrategy.COLUMN;
            }
            return false;
        }
        switch (timeZoneStorage.value()) {
            case COLUMN: {
                return true;
            }
            case AUTO: {
                return context.getBuildingOptions().getTimeZoneSupport() != TimeZoneSupport.NATIVE;
            }
        }
        return false;
    }
}

