/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.type.descriptor.WrapperOptions;

public class FilterJdbcParameter
implements JdbcParameter,
JdbcParameterBinder {
    private final JdbcMapping jdbcMapping;
    private final Object jdbcParameterValue;

    public FilterJdbcParameter(JdbcMapping jdbcMapping, Object jdbcParameterValue) {
        this.jdbcMapping = jdbcMapping;
        this.jdbcParameterValue = jdbcParameterValue;
    }

    @Override
    public JdbcParameterBinder getParameterBinder() {
        return this;
    }

    @Override
    public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) throws SQLException {
        this.jdbcMapping.getJdbcValueBinder().bind(statement, this.jdbcMapping.convertToRelationalValue(this.jdbcParameterValue), startPosition, (WrapperOptions)executionContext.getSession());
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.jdbcMapping;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        throw new IllegalStateException();
    }
}

