/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.internal.util.collections.Stack;

public final class StandardStack<T>
implements Stack<T> {
    private T[] elements;
    private int top = 0;
    private Class<T> type;

    public StandardStack(Class<T> type) {
        this.type = type;
    }

    public StandardStack(Class<T> type, T initial) {
        this(type);
        this.push(initial);
    }

    private void init() {
        this.elements = (Object[])Array.newInstance(this.type, 8);
        this.type = null;
    }

    @Override
    public void push(T e) {
        if (this.elements == null) {
            this.init();
        }
        if (this.top == this.elements.length) {
            this.grow();
        }
        this.elements[this.top++] = e;
    }

    @Override
    public T pop() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        T e = this.elements[--this.top];
        this.elements[this.top] = null;
        return e;
    }

    @Override
    public T getCurrent() {
        if (this.isEmpty()) {
            return null;
        }
        return this.elements[this.top - 1];
    }

    @Override
    public T peek(int offsetFromTop) {
        if (this.isEmpty()) {
            return null;
        }
        return this.elements[this.top - offsetFromTop - 1];
    }

    @Override
    public T getRoot() {
        if (this.isEmpty()) {
            return null;
        }
        return this.elements[0];
    }

    @Override
    public int depth() {
        return this.top;
    }

    @Override
    public boolean isEmpty() {
        return this.top == 0;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.top; ++i) {
            this.elements[i] = null;
        }
        this.top = 0;
    }

    @Override
    public void visitRootFirst(Consumer<T> action) {
        for (int i = 0; i < this.top; ++i) {
            action.accept(this.elements[i]);
        }
    }

    @Override
    public <X> X findCurrentFirst(Function<T, X> function) {
        for (int i = this.top - 1; i >= 0; --i) {
            X result = function.apply(this.elements[i]);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public <X, Y> X findCurrentFirstWithParameter(Y parameter, BiFunction<T, Y, X> biFunction) {
        for (int i = this.top - 1; i >= 0; --i) {
            X result = biFunction.apply(this.elements[i], parameter);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void grow() {
        int oldCapacity = this.elements.length;
        int jump = oldCapacity < 64 ? oldCapacity + 2 : oldCapacity >> 1;
        this.elements = Arrays.copyOf(this.elements, oldCapacity + jump);
    }
}

