/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.descriptor.java.CharacterJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.sql.DdlType;

public class DdlTypeImpl
implements DdlType {
    private final int sqlTypeCode;
    private final boolean isLob;
    private final String typeNamePattern;
    private final String castTypeNamePattern;
    private final String castTypeName;
    private final boolean castTypeNameIsStatic;
    final Dialect dialect;

    public DdlTypeImpl(int sqlTypeCode, String typeNamePattern, Dialect dialect) {
        this(sqlTypeCode, typeNamePattern, typeNamePattern, typeNamePattern, dialect);
    }

    public DdlTypeImpl(int sqlTypeCode, String typeNamePattern, String castTypeName, Dialect dialect) {
        this(sqlTypeCode, typeNamePattern, null, castTypeName, dialect);
    }

    public DdlTypeImpl(int sqlTypeCode, boolean isLob, String typeNamePattern, String castTypeName, Dialect dialect) {
        this(sqlTypeCode, isLob, typeNamePattern, null, castTypeName, dialect);
    }

    public DdlTypeImpl(int sqlTypeCode, String typeNamePattern, String castTypeNamePattern, String castTypeName, Dialect dialect) {
        this(sqlTypeCode, JdbcType.isLob(sqlTypeCode), typeNamePattern, castTypeNamePattern, castTypeName, dialect);
    }

    public DdlTypeImpl(int sqlTypeCode, boolean isLob, String typeNamePattern, String castTypeNamePattern, String castTypeName, Dialect dialect) {
        this.sqlTypeCode = sqlTypeCode;
        this.isLob = isLob;
        this.typeNamePattern = typeNamePattern;
        this.castTypeNamePattern = castTypeNamePattern;
        this.castTypeName = castTypeName;
        this.castTypeNameIsStatic = !castTypeName.contains("$s") && !castTypeName.contains("$p") && !castTypeName.contains("$l");
        this.dialect = dialect;
    }

    @Override
    public int getSqlTypeCode() {
        return this.sqlTypeCode;
    }

    @Override
    public String getRawTypeName() {
        int paren = this.typeNamePattern.indexOf(40);
        if (paren > 0) {
            int parenEnd = this.typeNamePattern.lastIndexOf(41);
            return parenEnd + 1 == this.typeNamePattern.length() ? this.typeNamePattern.substring(0, paren) : this.typeNamePattern.substring(0, paren) + this.typeNamePattern.substring(parenEnd + 1);
        }
        return this.typeNamePattern;
    }

    @Override
    public boolean isLob(Size size) {
        return this.isLob;
    }

    @Override
    public String getTypeName(Long size, Integer precision, Integer scale) {
        return DdlTypeImpl.replace(this.typeNamePattern, size, precision, scale);
    }

    @Override
    public String getCastTypeName(JdbcType jdbcType, JavaType<?> javaType, Long length, Integer precision, Integer scale) {
        if (length == null && precision == null) {
            return this.getCastTypeName(jdbcType, javaType);
        }
        Size size = this.dialect.getSizeStrategy().resolveSize(jdbcType, javaType, precision, scale, length);
        if (size.getPrecision() != null && size.getScale() == null) {
            size.setScale(javaType.getDefaultSqlScale(this.dialect, jdbcType));
        }
        return this.castTypeNamePattern == null ? this.getTypeName(size.getLength(), size.getPrecision(), size.getScale()) : DdlTypeImpl.replace(this.castTypeNamePattern, size.getLength(), size.getPrecision(), size.getScale());
    }

    @Override
    public String getCastTypeName(JdbcType jdbcType, JavaType<?> javaType) {
        if (javaType instanceof CharacterJavaType && jdbcType.isString()) {
            return this.getCastTypeName(jdbcType, javaType, 1L, null, null);
        }
        if (this.castTypeNameIsStatic) {
            return this.castTypeName;
        }
        Size size = this.dialect.getSizeStrategy().resolveSize(jdbcType, javaType, null, null, this.defaultLength(jdbcType));
        return DdlTypeImpl.replace(this.castTypeName, size.getLength(), size.getPrecision(), size.getScale());
    }

    private Long defaultLength(JdbcType jdbcType) {
        switch (jdbcType.getDdlTypeCode()) {
            case 12: {
                return this.dialect.getMaxVarcharLength();
            }
            case -9: {
                return this.dialect.getMaxNVarcharLength();
            }
            case -3: {
                return this.dialect.getMaxVarbinaryLength();
            }
        }
        return null;
    }

    public static String replace(String type, Long size, Integer precision, Integer scale) {
        if (scale != null) {
            type = StringHelper.replaceOnce(type, "$s", scale.toString());
        }
        if (size != null) {
            type = StringHelper.replaceOnce(type, "$l", size.toString());
        }
        if (precision != null) {
            type = StringHelper.replaceOnce(type, "$p", precision.toString());
        }
        return type;
    }
}

