/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.hibernate.common.deployment;

import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.visitors.PanacheEntityClassAccessorGenerationVisitor;
import java.util.function.BiFunction;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.objectweb.asm.ClassVisitor;

public class PanacheJpaEntityAccessorsEnhancer
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    private final IndexView indexView;
    private final MetamodelInfo modelInfo;

    public PanacheJpaEntityAccessorsEnhancer(IndexView index, MetamodelInfo modelInfo) {
        this.indexView = index;
        this.modelInfo = modelInfo;
    }

    @Override
    public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
        ClassInfo entityInfo = this.indexView.getClassByName(DotName.createSimple((String)className));
        EntityModel entityModel = this.modelInfo.getEntityModel(className);
        return new PanacheEntityClassAccessorGenerationVisitor(outputClassVisitor, entityInfo, entityModel);
    }
}

