/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import java.io.IOException;
import java.io.Writer;

public final class LineNumberWriter
extends Writer {
    private final Writer delegate;
    private int lineNumber = 1;

    public LineNumberWriter(Writer delegate) {
        this.delegate = delegate;
    }

    @Override
    public void write(int c) throws IOException {
        if (c == 10) {
            ++this.lineNumber;
        }
        this.delegate.write(c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            if (str.charAt(off + i) != '\n') continue;
            ++this.lineNumber;
        }
        this.delegate.write(str, off, len);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        this.append(csq, 0, csq.length());
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        for (int i = 0; i < end - start; ++i) {
            if (csq.charAt(start + i) != '\n') continue;
            ++this.lineNumber;
        }
        this.delegate.append(csq, start, end);
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.write(c);
        return this;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            if (cbuf[off + i] != '\n') continue;
            ++this.lineNumber;
        }
        this.delegate.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

