/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config._private.ConfigLogging;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;

class SecuritySupport {
    private SecuritySupport() {
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> {
            ClassLoader tccl = null;
            try {
                tccl = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException ex) {
                ConfigLogging.log.failedToRetrieveClassloader(ex);
            }
            return tccl;
        });
    }

    static void setAccessible(AccessibleObject object, boolean flag) {
        if (System.getSecurityManager() == null) {
            object.setAccessible(flag);
        } else {
            AccessController.doPrivileged(() -> {
                try {
                    object.setAccessible(flag);
                }
                catch (SecurityException ex) {
                    ConfigLogging.log.failedToSetAccessible(ex, object.toString());
                }
                return null;
            });
        }
    }

    static <T> Constructor<? extends T> getDeclaredConstructor(Class<T> clazz, Class<?> ... paramTypes) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredConstructor(paramTypes);
        }
        try {
            return AccessController.doPrivileged(() -> {
                Constructor constructor = null;
                try {
                    constructor = clazz.getDeclaredConstructor(paramTypes);
                }
                catch (SecurityException ex) {
                    ConfigLogging.log.failedToRetrieveDeclaredConstructor(ex, clazz.toString(), Arrays.toString(paramTypes));
                }
                return constructor;
            });
        }
        catch (PrivilegedActionException e) {
            Exception e2 = e.getException();
            if (e2 instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)e2;
            }
            throw new RuntimeException(e2);
        }
    }
}

