/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.stream.Stream;

public interface PathCollection
extends Iterable<Path> {
    public boolean isEmpty();

    public int size();

    public boolean isSinglePath();

    default public Path getSinglePath() {
        if (this.size() != 1) {
            throw new IllegalStateException("Paths collection expected to contain a single path but contains " + this.size());
        }
        return (Path)this.iterator().next();
    }

    public boolean contains(Path var1);

    public PathCollection add(Path ... var1);

    public PathCollection addFirst(Path ... var1);

    public PathCollection addAllFirst(Iterable<Path> var1);

    public Path resolveExistingOrNull(String var1);

    default public Stream<Path> stream() {
        ArrayList<Path> list = new ArrayList<Path>(this.size());
        for (Path p : this) {
            list.add(p);
        }
        return list.stream();
    }
}

