/*
 * Decompiled with CFR 0.152.
 */
package liquibase.logging.mdc.customobjects;

import java.io.PrintWriter;
import java.io.StringWriter;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.util.LiquibaseUtil;
import lombok.Generated;

public class ExceptionDetails
implements CustomMdcObject {
    private String primaryException;
    private String primaryExceptionReason;
    private String primaryExceptionSource;
    private String exception;

    public ExceptionDetails() {
    }

    public ExceptionDetails(Throwable exception, String source) {
        Throwable primaryException;
        for (primaryException = exception; primaryException != null && primaryException.getCause() != null; primaryException = primaryException.getCause()) {
        }
        if (primaryException != null) {
            if (primaryException instanceof LiquibaseException || source == null) {
                source = LiquibaseUtil.getBuildVersionInfo();
            }
            this.primaryException = primaryException.getClass().getSimpleName();
            this.primaryExceptionReason = primaryException.getMessage();
            this.primaryExceptionSource = source;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            this.exception = stringWriter.toString();
        }
    }

    public String getFormattedPrimaryException() {
        return this.getPrimaryException() != null ? String.format("ERROR: Exception Primary Class:  %s", this.getPrimaryException()) : "";
    }

    public String getFormattedPrimaryExceptionReason() {
        return this.getPrimaryExceptionReason() != null ? String.format("ERROR: Exception Primary Reason:  %s", this.getPrimaryExceptionReason()) : "";
    }

    public String getFormattedPrimaryExceptionSource() {
        return this.getPrimaryExceptionSource() != null ? String.format("ERROR: Exception Primary Source:  %s", this.getPrimaryExceptionSource()) : "";
    }

    public static String findSource(Database database) {
        try {
            String source;
            try {
                source = String.format("%s %s", database.getDatabaseProductName(), database.getDatabaseProductVersion());
            }
            catch (DatabaseException dbe) {
                source = database.getDatabaseProductName();
            }
            return source;
        }
        catch (RuntimeException ignored) {
            return database.getDisplayName();
        }
    }

    @Generated
    public String getPrimaryException() {
        return this.primaryException;
    }

    @Generated
    public String getPrimaryExceptionReason() {
        return this.primaryExceptionReason;
    }

    @Generated
    public String getPrimaryExceptionSource() {
        return this.primaryExceptionSource;
    }

    @Generated
    public String getException() {
        return this.exception;
    }

    @Generated
    public void setPrimaryException(String primaryException) {
        this.primaryException = primaryException;
    }

    @Generated
    public void setPrimaryExceptionReason(String primaryExceptionReason) {
        this.primaryExceptionReason = primaryExceptionReason;
    }

    @Generated
    public void setPrimaryExceptionSource(String primaryExceptionSource) {
        this.primaryExceptionSource = primaryExceptionSource;
    }

    @Generated
    public void setException(String exception) {
        this.exception = exception;
    }
}

