/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.cuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_EXT_SEM_SIGNAL_NODE_PARAMS
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EXTSEMARRAY;
    public static final int PARAMSARRAY;
    public static final int NUMEXTSEMS;

    public CUDA_EXT_SEM_SIGNAL_NODE_PARAMS(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUexternalSemaphore *")
    public PointerBuffer extSemArray() {
        return CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.nextSemArray(this.address());
    }

    @NativeType(value="CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS const *")
    public CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS.Buffer paramsArray() {
        return CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.nparamsArray(this.address());
    }

    @NativeType(value="unsigned int")
    public int numExtSems() {
        return CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.nnumExtSems(this.address());
    }

    public CUDA_EXT_SEM_SIGNAL_NODE_PARAMS extSemArray(@NativeType(value="CUexternalSemaphore *") PointerBuffer value) {
        CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.nextSemArray(this.address(), value);
        return this;
    }

    public CUDA_EXT_SEM_SIGNAL_NODE_PARAMS paramsArray(@NativeType(value="CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS const *") CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS.Buffer value) {
        CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.nparamsArray(this.address(), value);
        return this;
    }

    public CUDA_EXT_SEM_SIGNAL_NODE_PARAMS numExtSems(@NativeType(value="unsigned int") int value) {
        CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.nnumExtSems(this.address(), value);
        return this;
    }

    public CUDA_EXT_SEM_SIGNAL_NODE_PARAMS set(PointerBuffer extSemArray, CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS.Buffer paramsArray, int numExtSems) {
        this.extSemArray(extSemArray);
        this.paramsArray(paramsArray);
        this.numExtSems(numExtSems);
        return this;
    }

    public CUDA_EXT_SEM_SIGNAL_NODE_PARAMS set(CUDA_EXT_SEM_SIGNAL_NODE_PARAMS src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUDA_EXT_SEM_SIGNAL_NODE_PARAMS malloc() {
        return (CUDA_EXT_SEM_SIGNAL_NODE_PARAMS)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.wrap(CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CUDA_EXT_SEM_SIGNAL_NODE_PARAMS calloc() {
        return (CUDA_EXT_SEM_SIGNAL_NODE_PARAMS)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.wrap(CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CUDA_EXT_SEM_SIGNAL_NODE_PARAMS create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CUDA_EXT_SEM_SIGNAL_NODE_PARAMS)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.wrap(CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CUDA_EXT_SEM_SIGNAL_NODE_PARAMS create(long address) {
        return (CUDA_EXT_SEM_SIGNAL_NODE_PARAMS)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.wrap(CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.class, (long)address);
    }

    @Nullable
    public static CUDA_EXT_SEM_SIGNAL_NODE_PARAMS createSafe(long address) {
        return address == 0L ? null : (CUDA_EXT_SEM_SIGNAL_NODE_PARAMS)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.wrap(CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CUDA_EXT_SEM_SIGNAL_NODE_PARAMS malloc(MemoryStack stack) {
        return (CUDA_EXT_SEM_SIGNAL_NODE_PARAMS)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.wrap(CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUDA_EXT_SEM_SIGNAL_NODE_PARAMS calloc(MemoryStack stack) {
        return (CUDA_EXT_SEM_SIGNAL_NODE_PARAMS)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.wrap(CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static PointerBuffer nextSemArray(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)EXTSEMARRAY)), (int)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.nnumExtSems(struct));
    }

    public static CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS.Buffer nparamsArray(long struct) {
        return CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS.create(MemoryUtil.memGetAddress((long)(struct + (long)PARAMSARRAY)), CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.nnumExtSems(struct));
    }

    public static int nnumExtSems(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMEXTSEMS);
    }

    public static void nextSemArray(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)EXTSEMARRAY), (long)MemoryUtil.memAddress((CustomBuffer)value));
    }

    public static void nparamsArray(long struct, CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PARAMSARRAY), (long)value.address());
    }

    public static void nnumExtSems(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUMEXTSEMS, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)EXTSEMARRAY)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PARAMSARRAY)));
    }

    static {
        Struct.Layout layout = CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.__struct((Struct.Member[])new Struct.Member[]{CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.__member((int)POINTER_SIZE), CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.__member((int)POINTER_SIZE), CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EXTSEMARRAY = layout.offsetof(0);
        PARAMSARRAY = layout.offsetof(1);
        NUMEXTSEMS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CUDA_EXT_SEM_SIGNAL_NODE_PARAMS, Buffer>
    implements NativeResource {
        private static final CUDA_EXT_SEM_SIGNAL_NODE_PARAMS ELEMENT_FACTORY = CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUDA_EXT_SEM_SIGNAL_NODE_PARAMS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUexternalSemaphore *")
        public PointerBuffer extSemArray() {
            return CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.nextSemArray(this.address());
        }

        @NativeType(value="CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS const *")
        public CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS.Buffer paramsArray() {
            return CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.nparamsArray(this.address());
        }

        @NativeType(value="unsigned int")
        public int numExtSems() {
            return CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.nnumExtSems(this.address());
        }

        public Buffer extSemArray(@NativeType(value="CUexternalSemaphore *") PointerBuffer value) {
            CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.nextSemArray(this.address(), value);
            return this;
        }

        public Buffer paramsArray(@NativeType(value="CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS const *") CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS.Buffer value) {
            CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.nparamsArray(this.address(), value);
            return this;
        }

        public Buffer numExtSems(@NativeType(value="unsigned int") int value) {
            CUDA_EXT_SEM_SIGNAL_NODE_PARAMS.nnumExtSems(this.address(), value);
            return this;
        }
    }
}

