/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_RESOURCE_VIEW_DESC
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMAT;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEPTH;
    public static final int FIRSTMIPMAPLEVEL;
    public static final int LASTMIPMAPLEVEL;
    public static final int FIRSTLAYER;
    public static final int LASTLAYER;
    public static final int RESERVED;

    public CUDA_RESOURCE_VIEW_DESC(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_RESOURCE_VIEW_DESC.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUresourceViewFormat")
    public int format() {
        return CUDA_RESOURCE_VIEW_DESC.nformat(this.address());
    }

    @NativeType(value="size_t")
    public long width() {
        return CUDA_RESOURCE_VIEW_DESC.nwidth(this.address());
    }

    @NativeType(value="size_t")
    public long height() {
        return CUDA_RESOURCE_VIEW_DESC.nheight(this.address());
    }

    @NativeType(value="size_t")
    public long depth() {
        return CUDA_RESOURCE_VIEW_DESC.ndepth(this.address());
    }

    @NativeType(value="unsigned int")
    public int firstMipmapLevel() {
        return CUDA_RESOURCE_VIEW_DESC.nfirstMipmapLevel(this.address());
    }

    @NativeType(value="unsigned int")
    public int lastMipmapLevel() {
        return CUDA_RESOURCE_VIEW_DESC.nlastMipmapLevel(this.address());
    }

    @NativeType(value="unsigned int")
    public int firstLayer() {
        return CUDA_RESOURCE_VIEW_DESC.nfirstLayer(this.address());
    }

    @NativeType(value="unsigned int")
    public int lastLayer() {
        return CUDA_RESOURCE_VIEW_DESC.nlastLayer(this.address());
    }

    @NativeType(value="unsigned int[16]")
    public IntBuffer reserved() {
        return CUDA_RESOURCE_VIEW_DESC.nreserved(this.address());
    }

    @NativeType(value="unsigned int")
    public int reserved(int index) {
        return CUDA_RESOURCE_VIEW_DESC.nreserved(this.address(), index);
    }

    public CUDA_RESOURCE_VIEW_DESC format(@NativeType(value="CUresourceViewFormat") int value) {
        CUDA_RESOURCE_VIEW_DESC.nformat(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_VIEW_DESC width(@NativeType(value="size_t") long value) {
        CUDA_RESOURCE_VIEW_DESC.nwidth(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_VIEW_DESC height(@NativeType(value="size_t") long value) {
        CUDA_RESOURCE_VIEW_DESC.nheight(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_VIEW_DESC depth(@NativeType(value="size_t") long value) {
        CUDA_RESOURCE_VIEW_DESC.ndepth(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_VIEW_DESC firstMipmapLevel(@NativeType(value="unsigned int") int value) {
        CUDA_RESOURCE_VIEW_DESC.nfirstMipmapLevel(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_VIEW_DESC lastMipmapLevel(@NativeType(value="unsigned int") int value) {
        CUDA_RESOURCE_VIEW_DESC.nlastMipmapLevel(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_VIEW_DESC firstLayer(@NativeType(value="unsigned int") int value) {
        CUDA_RESOURCE_VIEW_DESC.nfirstLayer(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_VIEW_DESC lastLayer(@NativeType(value="unsigned int") int value) {
        CUDA_RESOURCE_VIEW_DESC.nlastLayer(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_VIEW_DESC reserved(@NativeType(value="unsigned int[16]") IntBuffer value) {
        CUDA_RESOURCE_VIEW_DESC.nreserved(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_VIEW_DESC reserved(int index, @NativeType(value="unsigned int") int value) {
        CUDA_RESOURCE_VIEW_DESC.nreserved(this.address(), index, value);
        return this;
    }

    public CUDA_RESOURCE_VIEW_DESC set(int format, long width, long height, long depth, int firstMipmapLevel, int lastMipmapLevel, int firstLayer, int lastLayer, IntBuffer reserved) {
        this.format(format);
        this.width(width);
        this.height(height);
        this.depth(depth);
        this.firstMipmapLevel(firstMipmapLevel);
        this.lastMipmapLevel(lastMipmapLevel);
        this.firstLayer(firstLayer);
        this.lastLayer(lastLayer);
        this.reserved(reserved);
        return this;
    }

    public CUDA_RESOURCE_VIEW_DESC set(CUDA_RESOURCE_VIEW_DESC src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUDA_RESOURCE_VIEW_DESC malloc() {
        return (CUDA_RESOURCE_VIEW_DESC)CUDA_RESOURCE_VIEW_DESC.wrap(CUDA_RESOURCE_VIEW_DESC.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CUDA_RESOURCE_VIEW_DESC calloc() {
        return (CUDA_RESOURCE_VIEW_DESC)CUDA_RESOURCE_VIEW_DESC.wrap(CUDA_RESOURCE_VIEW_DESC.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CUDA_RESOURCE_VIEW_DESC create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CUDA_RESOURCE_VIEW_DESC)CUDA_RESOURCE_VIEW_DESC.wrap(CUDA_RESOURCE_VIEW_DESC.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CUDA_RESOURCE_VIEW_DESC create(long address) {
        return (CUDA_RESOURCE_VIEW_DESC)CUDA_RESOURCE_VIEW_DESC.wrap(CUDA_RESOURCE_VIEW_DESC.class, (long)address);
    }

    @Nullable
    public static CUDA_RESOURCE_VIEW_DESC createSafe(long address) {
        return address == 0L ? null : (CUDA_RESOURCE_VIEW_DESC)CUDA_RESOURCE_VIEW_DESC.wrap(CUDA_RESOURCE_VIEW_DESC.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CUDA_RESOURCE_VIEW_DESC.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CUDA_RESOURCE_VIEW_DESC.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CUDA_RESOURCE_VIEW_DESC.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_RESOURCE_VIEW_DESC.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CUDA_RESOURCE_VIEW_DESC.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CUDA_RESOURCE_VIEW_DESC.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CUDA_RESOURCE_VIEW_DESC.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static CUDA_RESOURCE_VIEW_DESC mallocStack() {
        return CUDA_RESOURCE_VIEW_DESC.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_RESOURCE_VIEW_DESC callocStack() {
        return CUDA_RESOURCE_VIEW_DESC.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_RESOURCE_VIEW_DESC mallocStack(MemoryStack stack) {
        return CUDA_RESOURCE_VIEW_DESC.malloc(stack);
    }

    @Deprecated
    public static CUDA_RESOURCE_VIEW_DESC callocStack(MemoryStack stack) {
        return CUDA_RESOURCE_VIEW_DESC.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUDA_RESOURCE_VIEW_DESC.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUDA_RESOURCE_VIEW_DESC.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUDA_RESOURCE_VIEW_DESC.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUDA_RESOURCE_VIEW_DESC.calloc(capacity, stack);
    }

    public static CUDA_RESOURCE_VIEW_DESC malloc(MemoryStack stack) {
        return (CUDA_RESOURCE_VIEW_DESC)CUDA_RESOURCE_VIEW_DESC.wrap(CUDA_RESOURCE_VIEW_DESC.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUDA_RESOURCE_VIEW_DESC calloc(MemoryStack stack) {
        return (CUDA_RESOURCE_VIEW_DESC)CUDA_RESOURCE_VIEW_DESC.wrap(CUDA_RESOURCE_VIEW_DESC.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CUDA_RESOURCE_VIEW_DESC.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CUDA_RESOURCE_VIEW_DESC.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nformat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static long nwidth(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)WIDTH));
    }

    public static long nheight(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HEIGHT));
    }

    public static long ndepth(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DEPTH));
    }

    public static int nfirstMipmapLevel(long struct) {
        return UNSAFE.getInt(null, struct + (long)FIRSTMIPMAPLEVEL);
    }

    public static int nlastMipmapLevel(long struct) {
        return UNSAFE.getInt(null, struct + (long)LASTMIPMAPLEVEL);
    }

    public static int nfirstLayer(long struct) {
        return UNSAFE.getInt(null, struct + (long)FIRSTLAYER);
    }

    public static int nlastLayer(long struct) {
        return UNSAFE.getInt(null, struct + (long)LASTLAYER);
    }

    public static IntBuffer nreserved(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)RESERVED), (int)16);
    }

    public static int nreserved(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)RESERVED + Checks.check((int)index, (int)16) * 4L);
    }

    public static void nformat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORMAT, value);
    }

    public static void nwidth(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WIDTH), (long)value);
    }

    public static void nheight(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HEIGHT), (long)value);
    }

    public static void ndepth(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DEPTH), (long)value);
    }

    public static void nfirstMipmapLevel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FIRSTMIPMAPLEVEL, value);
    }

    public static void nlastMipmapLevel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LASTMIPMAPLEVEL, value);
    }

    public static void nfirstLayer(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FIRSTLAYER, value);
    }

    public static void nlastLayer(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LASTLAYER, value);
    }

    public static void nreserved(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)16);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)RESERVED), (long)(value.remaining() * 4));
    }

    public static void nreserved(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)RESERVED + Checks.check((int)index, (int)16) * 4L, value);
    }

    static {
        Struct.Layout layout = CUDA_RESOURCE_VIEW_DESC.__struct((Struct.Member[])new Struct.Member[]{CUDA_RESOURCE_VIEW_DESC.__member((int)4), CUDA_RESOURCE_VIEW_DESC.__member((int)POINTER_SIZE), CUDA_RESOURCE_VIEW_DESC.__member((int)POINTER_SIZE), CUDA_RESOURCE_VIEW_DESC.__member((int)POINTER_SIZE), CUDA_RESOURCE_VIEW_DESC.__member((int)4), CUDA_RESOURCE_VIEW_DESC.__member((int)4), CUDA_RESOURCE_VIEW_DESC.__member((int)4), CUDA_RESOURCE_VIEW_DESC.__member((int)4), CUDA_RESOURCE_VIEW_DESC.__array((int)4, (int)16)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMAT = layout.offsetof(0);
        WIDTH = layout.offsetof(1);
        HEIGHT = layout.offsetof(2);
        DEPTH = layout.offsetof(3);
        FIRSTMIPMAPLEVEL = layout.offsetof(4);
        LASTMIPMAPLEVEL = layout.offsetof(5);
        FIRSTLAYER = layout.offsetof(6);
        LASTLAYER = layout.offsetof(7);
        RESERVED = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<CUDA_RESOURCE_VIEW_DESC, Buffer>
    implements NativeResource {
        private static final CUDA_RESOURCE_VIEW_DESC ELEMENT_FACTORY = CUDA_RESOURCE_VIEW_DESC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUDA_RESOURCE_VIEW_DESC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUresourceViewFormat")
        public int format() {
            return CUDA_RESOURCE_VIEW_DESC.nformat(this.address());
        }

        @NativeType(value="size_t")
        public long width() {
            return CUDA_RESOURCE_VIEW_DESC.nwidth(this.address());
        }

        @NativeType(value="size_t")
        public long height() {
            return CUDA_RESOURCE_VIEW_DESC.nheight(this.address());
        }

        @NativeType(value="size_t")
        public long depth() {
            return CUDA_RESOURCE_VIEW_DESC.ndepth(this.address());
        }

        @NativeType(value="unsigned int")
        public int firstMipmapLevel() {
            return CUDA_RESOURCE_VIEW_DESC.nfirstMipmapLevel(this.address());
        }

        @NativeType(value="unsigned int")
        public int lastMipmapLevel() {
            return CUDA_RESOURCE_VIEW_DESC.nlastMipmapLevel(this.address());
        }

        @NativeType(value="unsigned int")
        public int firstLayer() {
            return CUDA_RESOURCE_VIEW_DESC.nfirstLayer(this.address());
        }

        @NativeType(value="unsigned int")
        public int lastLayer() {
            return CUDA_RESOURCE_VIEW_DESC.nlastLayer(this.address());
        }

        @NativeType(value="unsigned int[16]")
        public IntBuffer reserved() {
            return CUDA_RESOURCE_VIEW_DESC.nreserved(this.address());
        }

        @NativeType(value="unsigned int")
        public int reserved(int index) {
            return CUDA_RESOURCE_VIEW_DESC.nreserved(this.address(), index);
        }

        public Buffer format(@NativeType(value="CUresourceViewFormat") int value) {
            CUDA_RESOURCE_VIEW_DESC.nformat(this.address(), value);
            return this;
        }

        public Buffer width(@NativeType(value="size_t") long value) {
            CUDA_RESOURCE_VIEW_DESC.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="size_t") long value) {
            CUDA_RESOURCE_VIEW_DESC.nheight(this.address(), value);
            return this;
        }

        public Buffer depth(@NativeType(value="size_t") long value) {
            CUDA_RESOURCE_VIEW_DESC.ndepth(this.address(), value);
            return this;
        }

        public Buffer firstMipmapLevel(@NativeType(value="unsigned int") int value) {
            CUDA_RESOURCE_VIEW_DESC.nfirstMipmapLevel(this.address(), value);
            return this;
        }

        public Buffer lastMipmapLevel(@NativeType(value="unsigned int") int value) {
            CUDA_RESOURCE_VIEW_DESC.nlastMipmapLevel(this.address(), value);
            return this;
        }

        public Buffer firstLayer(@NativeType(value="unsigned int") int value) {
            CUDA_RESOURCE_VIEW_DESC.nfirstLayer(this.address(), value);
            return this;
        }

        public Buffer lastLayer(@NativeType(value="unsigned int") int value) {
            CUDA_RESOURCE_VIEW_DESC.nlastLayer(this.address(), value);
            return this;
        }

        public Buffer reserved(@NativeType(value="unsigned int[16]") IntBuffer value) {
            CUDA_RESOURCE_VIEW_DESC.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="unsigned int") int value) {
            CUDA_RESOURCE_VIEW_DESC.nreserved(this.address(), index, value);
            return this;
        }
    }
}

