/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkPhysicalDeviceToolProperties;

public class EXTToolingInfo {
    public static final int VK_EXT_TOOLING_INFO_SPEC_VERSION = 1;
    public static final String VK_EXT_TOOLING_INFO_EXTENSION_NAME = "VK_EXT_tooling_info";
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES_EXT = 1000245000;
    public static final int VK_TOOL_PURPOSE_VALIDATION_BIT_EXT = 1;
    public static final int VK_TOOL_PURPOSE_PROFILING_BIT_EXT = 2;
    public static final int VK_TOOL_PURPOSE_TRACING_BIT_EXT = 4;
    public static final int VK_TOOL_PURPOSE_ADDITIONAL_FEATURES_BIT_EXT = 8;
    public static final int VK_TOOL_PURPOSE_MODIFYING_FEATURES_BIT_EXT = 16;
    public static final int VK_TOOL_PURPOSE_DEBUG_REPORTING_BIT_EXT = 32;
    public static final int VK_TOOL_PURPOSE_DEBUG_MARKERS_BIT_EXT = 64;

    protected EXTToolingInfo() {
        throw new UnsupportedOperationException();
    }

    public static int nvkGetPhysicalDeviceToolPropertiesEXT(VkPhysicalDevice physicalDevice, long pToolCount, long pToolProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceToolPropertiesEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)physicalDevice.address(), (long)pToolCount, (long)pToolProperties, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceToolPropertiesEXT(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t *") IntBuffer pToolCount, @Nullable @NativeType(value="VkPhysicalDeviceToolProperties *") VkPhysicalDeviceToolProperties.Buffer pToolProperties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pToolCount, (int)1);
            Checks.checkSafe((CustomBuffer)pToolProperties, (int)pToolCount.get(pToolCount.position()));
        }
        return EXTToolingInfo.nvkGetPhysicalDeviceToolPropertiesEXT(physicalDevice, MemoryUtil.memAddress((IntBuffer)pToolCount), MemoryUtil.memAddressSafe((Pointer)pToolProperties));
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceToolPropertiesEXT(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t *") int[] pToolCount, @Nullable @NativeType(value="VkPhysicalDeviceToolProperties *") VkPhysicalDeviceToolProperties.Buffer pToolProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceToolPropertiesEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pToolCount, (int)1);
            Checks.checkSafe((CustomBuffer)pToolProperties, (int)pToolCount[0]);
        }
        return JNI.callPPPI((long)physicalDevice.address(), (int[])pToolCount, (long)MemoryUtil.memAddressSafe((Pointer)pToolProperties), (long)__functionAddress);
    }
}

