/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkRenderPassMultiviewCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SUBPASSCOUNT;
    public static final int PVIEWMASKS;
    public static final int DEPENDENCYCOUNT;
    public static final int PVIEWOFFSETS;
    public static final int CORRELATIONMASKCOUNT;
    public static final int PCORRELATIONMASKS;

    public VkRenderPassMultiviewCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkRenderPassMultiviewCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderPassMultiviewCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderPassMultiviewCreateInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int subpassCount() {
        return VkRenderPassMultiviewCreateInfo.nsubpassCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pViewMasks() {
        return VkRenderPassMultiviewCreateInfo.npViewMasks(this.address());
    }

    @NativeType(value="uint32_t")
    public int dependencyCount() {
        return VkRenderPassMultiviewCreateInfo.ndependencyCount(this.address());
    }

    @Nullable
    @NativeType(value="int32_t const *")
    public IntBuffer pViewOffsets() {
        return VkRenderPassMultiviewCreateInfo.npViewOffsets(this.address());
    }

    @NativeType(value="uint32_t")
    public int correlationMaskCount() {
        return VkRenderPassMultiviewCreateInfo.ncorrelationMaskCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pCorrelationMasks() {
        return VkRenderPassMultiviewCreateInfo.npCorrelationMasks(this.address());
    }

    public VkRenderPassMultiviewCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassMultiviewCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassMultiviewCreateInfo sType$Default() {
        return this.sType(1000053000);
    }

    public VkRenderPassMultiviewCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkRenderPassMultiviewCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassMultiviewCreateInfo pViewMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkRenderPassMultiviewCreateInfo.npViewMasks(this.address(), value);
        return this;
    }

    public VkRenderPassMultiviewCreateInfo pViewOffsets(@Nullable @NativeType(value="int32_t const *") IntBuffer value) {
        VkRenderPassMultiviewCreateInfo.npViewOffsets(this.address(), value);
        return this;
    }

    public VkRenderPassMultiviewCreateInfo pCorrelationMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkRenderPassMultiviewCreateInfo.npCorrelationMasks(this.address(), value);
        return this;
    }

    public VkRenderPassMultiviewCreateInfo set(int sType, long pNext, @Nullable IntBuffer pViewMasks, @Nullable IntBuffer pViewOffsets, @Nullable IntBuffer pCorrelationMasks) {
        this.sType(sType);
        this.pNext(pNext);
        this.pViewMasks(pViewMasks);
        this.pViewOffsets(pViewOffsets);
        this.pCorrelationMasks(pCorrelationMasks);
        return this;
    }

    public VkRenderPassMultiviewCreateInfo set(VkRenderPassMultiviewCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkRenderPassMultiviewCreateInfo malloc() {
        return (VkRenderPassMultiviewCreateInfo)VkRenderPassMultiviewCreateInfo.wrap(VkRenderPassMultiviewCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfo calloc() {
        return (VkRenderPassMultiviewCreateInfo)VkRenderPassMultiviewCreateInfo.wrap(VkRenderPassMultiviewCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkRenderPassMultiviewCreateInfo)VkRenderPassMultiviewCreateInfo.wrap(VkRenderPassMultiviewCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkRenderPassMultiviewCreateInfo create(long address) {
        return (VkRenderPassMultiviewCreateInfo)VkRenderPassMultiviewCreateInfo.wrap(VkRenderPassMultiviewCreateInfo.class, (long)address);
    }

    @Nullable
    public static VkRenderPassMultiviewCreateInfo createSafe(long address) {
        return address == 0L ? null : (VkRenderPassMultiviewCreateInfo)VkRenderPassMultiviewCreateInfo.wrap(VkRenderPassMultiviewCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkRenderPassMultiviewCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkRenderPassMultiviewCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkRenderPassMultiviewCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderPassMultiviewCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkRenderPassMultiviewCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkRenderPassMultiviewCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkRenderPassMultiviewCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkRenderPassMultiviewCreateInfo mallocStack() {
        return VkRenderPassMultiviewCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkRenderPassMultiviewCreateInfo callocStack() {
        return VkRenderPassMultiviewCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkRenderPassMultiviewCreateInfo mallocStack(MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkRenderPassMultiviewCreateInfo callocStack(MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkRenderPassMultiviewCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkRenderPassMultiviewCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfo.calloc(capacity, stack);
    }

    public static VkRenderPassMultiviewCreateInfo malloc(MemoryStack stack) {
        return (VkRenderPassMultiviewCreateInfo)VkRenderPassMultiviewCreateInfo.wrap(VkRenderPassMultiviewCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfo calloc(MemoryStack stack) {
        return (VkRenderPassMultiviewCreateInfo)VkRenderPassMultiviewCreateInfo.wrap(VkRenderPassMultiviewCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkRenderPassMultiviewCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkRenderPassMultiviewCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nsubpassCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBPASSCOUNT);
    }

    @Nullable
    public static IntBuffer npViewMasks(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PVIEWMASKS)), (int)VkRenderPassMultiviewCreateInfo.nsubpassCount(struct));
    }

    public static int ndependencyCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPENDENCYCOUNT);
    }

    @Nullable
    public static IntBuffer npViewOffsets(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PVIEWOFFSETS)), (int)VkRenderPassMultiviewCreateInfo.ndependencyCount(struct));
    }

    public static int ncorrelationMaskCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)CORRELATIONMASKCOUNT);
    }

    @Nullable
    public static IntBuffer npCorrelationMasks(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PCORRELATIONMASKS)), (int)VkRenderPassMultiviewCreateInfo.ncorrelationMaskCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsubpassCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBPASSCOUNT, value);
    }

    public static void npViewMasks(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PVIEWMASKS), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkRenderPassMultiviewCreateInfo.nsubpassCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ndependencyCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEPENDENCYCOUNT, value);
    }

    public static void npViewOffsets(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PVIEWOFFSETS), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkRenderPassMultiviewCreateInfo.ndependencyCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ncorrelationMaskCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CORRELATIONMASKCOUNT, value);
    }

    public static void npCorrelationMasks(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCORRELATIONMASKS), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkRenderPassMultiviewCreateInfo.ncorrelationMaskCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkRenderPassMultiviewCreateInfo.nsubpassCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PVIEWMASKS)));
        }
        if (VkRenderPassMultiviewCreateInfo.ndependencyCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PVIEWOFFSETS)));
        }
        if (VkRenderPassMultiviewCreateInfo.ncorrelationMaskCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PCORRELATIONMASKS)));
        }
    }

    static {
        Struct.Layout layout = VkRenderPassMultiviewCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkRenderPassMultiviewCreateInfo.__member((int)4), VkRenderPassMultiviewCreateInfo.__member((int)POINTER_SIZE), VkRenderPassMultiviewCreateInfo.__member((int)4), VkRenderPassMultiviewCreateInfo.__member((int)POINTER_SIZE), VkRenderPassMultiviewCreateInfo.__member((int)4), VkRenderPassMultiviewCreateInfo.__member((int)POINTER_SIZE), VkRenderPassMultiviewCreateInfo.__member((int)4), VkRenderPassMultiviewCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SUBPASSCOUNT = layout.offsetof(2);
        PVIEWMASKS = layout.offsetof(3);
        DEPENDENCYCOUNT = layout.offsetof(4);
        PVIEWOFFSETS = layout.offsetof(5);
        CORRELATIONMASKCOUNT = layout.offsetof(6);
        PCORRELATIONMASKS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkRenderPassMultiviewCreateInfo, Buffer>
    implements NativeResource {
        private static final VkRenderPassMultiviewCreateInfo ELEMENT_FACTORY = VkRenderPassMultiviewCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkRenderPassMultiviewCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderPassMultiviewCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderPassMultiviewCreateInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int subpassCount() {
            return VkRenderPassMultiviewCreateInfo.nsubpassCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pViewMasks() {
            return VkRenderPassMultiviewCreateInfo.npViewMasks(this.address());
        }

        @NativeType(value="uint32_t")
        public int dependencyCount() {
            return VkRenderPassMultiviewCreateInfo.ndependencyCount(this.address());
        }

        @Nullable
        @NativeType(value="int32_t const *")
        public IntBuffer pViewOffsets() {
            return VkRenderPassMultiviewCreateInfo.npViewOffsets(this.address());
        }

        @NativeType(value="uint32_t")
        public int correlationMaskCount() {
            return VkRenderPassMultiviewCreateInfo.ncorrelationMaskCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pCorrelationMasks() {
            return VkRenderPassMultiviewCreateInfo.npCorrelationMasks(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassMultiviewCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000053000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassMultiviewCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pViewMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkRenderPassMultiviewCreateInfo.npViewMasks(this.address(), value);
            return this;
        }

        public Buffer pViewOffsets(@Nullable @NativeType(value="int32_t const *") IntBuffer value) {
            VkRenderPassMultiviewCreateInfo.npViewOffsets(this.address(), value);
            return this;
        }

        public Buffer pCorrelationMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkRenderPassMultiviewCreateInfo.npCorrelationMasks(this.address(), value);
            return this;
        }
    }
}

