/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDedicatedAllocationMemoryAllocateInfoNV;
import org.lwjgl.vulkan.VkExportMemoryAllocateInfo;
import org.lwjgl.vulkan.VkExportMemoryAllocateInfoKHR;
import org.lwjgl.vulkan.VkExportMemoryAllocateInfoNV;
import org.lwjgl.vulkan.VkExportMemoryWin32HandleInfoKHR;
import org.lwjgl.vulkan.VkExportMemoryWin32HandleInfoNV;
import org.lwjgl.vulkan.VkImportMemoryFdInfoKHR;
import org.lwjgl.vulkan.VkImportMemoryHostPointerInfoEXT;
import org.lwjgl.vulkan.VkImportMemoryWin32HandleInfoKHR;
import org.lwjgl.vulkan.VkImportMemoryWin32HandleInfoNV;
import org.lwjgl.vulkan.VkMemoryAllocateFlagsInfo;
import org.lwjgl.vulkan.VkMemoryAllocateFlagsInfoKHR;
import org.lwjgl.vulkan.VkMemoryDedicatedAllocateInfo;
import org.lwjgl.vulkan.VkMemoryDedicatedAllocateInfoKHR;
import org.lwjgl.vulkan.VkMemoryOpaqueCaptureAddressAllocateInfo;
import org.lwjgl.vulkan.VkMemoryOpaqueCaptureAddressAllocateInfoKHR;
import org.lwjgl.vulkan.VkMemoryPriorityAllocateInfoEXT;

public class VmaPoolCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MEMORYTYPEINDEX;
    public static final int FLAGS;
    public static final int BLOCKSIZE;
    public static final int MINBLOCKCOUNT;
    public static final int MAXBLOCKCOUNT;
    public static final int PRIORITY;
    public static final int MINALLOCATIONALIGNMENT;
    public static final int PMEMORYALLOCATENEXT;

    public VmaPoolCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaPoolCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int memoryTypeIndex() {
        return VmaPoolCreateInfo.nmemoryTypeIndex(this.address());
    }

    @NativeType(value="VmaPoolCreateFlags")
    public int flags() {
        return VmaPoolCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long blockSize() {
        return VmaPoolCreateInfo.nblockSize(this.address());
    }

    @NativeType(value="size_t")
    public long minBlockCount() {
        return VmaPoolCreateInfo.nminBlockCount(this.address());
    }

    @NativeType(value="size_t")
    public long maxBlockCount() {
        return VmaPoolCreateInfo.nmaxBlockCount(this.address());
    }

    public float priority() {
        return VmaPoolCreateInfo.npriority(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long minAllocationAlignment() {
        return VmaPoolCreateInfo.nminAllocationAlignment(this.address());
    }

    @NativeType(value="void *")
    public long pMemoryAllocateNext() {
        return VmaPoolCreateInfo.npMemoryAllocateNext(this.address());
    }

    public VmaPoolCreateInfo memoryTypeIndex(@NativeType(value="uint32_t") int value) {
        VmaPoolCreateInfo.nmemoryTypeIndex(this.address(), value);
        return this;
    }

    public VmaPoolCreateInfo flags(@NativeType(value="VmaPoolCreateFlags") int value) {
        VmaPoolCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VmaPoolCreateInfo blockSize(@NativeType(value="VkDeviceSize") long value) {
        VmaPoolCreateInfo.nblockSize(this.address(), value);
        return this;
    }

    public VmaPoolCreateInfo minBlockCount(@NativeType(value="size_t") long value) {
        VmaPoolCreateInfo.nminBlockCount(this.address(), value);
        return this;
    }

    public VmaPoolCreateInfo maxBlockCount(@NativeType(value="size_t") long value) {
        VmaPoolCreateInfo.nmaxBlockCount(this.address(), value);
        return this;
    }

    public VmaPoolCreateInfo priority(float value) {
        VmaPoolCreateInfo.npriority(this.address(), value);
        return this;
    }

    public VmaPoolCreateInfo minAllocationAlignment(@NativeType(value="VkDeviceSize") long value) {
        VmaPoolCreateInfo.nminAllocationAlignment(this.address(), value);
        return this;
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(@NativeType(value="void *") long value) {
        VmaPoolCreateInfo.npMemoryAllocateNext(this.address(), value);
        return this;
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkDedicatedAllocationMemoryAllocateInfoNV value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkExportMemoryAllocateInfo value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkExportMemoryAllocateInfoKHR value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkExportMemoryAllocateInfoNV value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkExportMemoryWin32HandleInfoKHR value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkExportMemoryWin32HandleInfoNV value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkImportMemoryFdInfoKHR value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkImportMemoryHostPointerInfoEXT value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkImportMemoryWin32HandleInfoKHR value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkImportMemoryWin32HandleInfoNV value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkMemoryAllocateFlagsInfo value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkMemoryAllocateFlagsInfoKHR value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkMemoryDedicatedAllocateInfo value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkMemoryDedicatedAllocateInfoKHR value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkMemoryOpaqueCaptureAddressAllocateInfo value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkMemoryOpaqueCaptureAddressAllocateInfoKHR value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo pMemoryAllocateNext(VkMemoryPriorityAllocateInfoEXT value) {
        return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
    }

    public VmaPoolCreateInfo set(int memoryTypeIndex, int flags, long blockSize, long minBlockCount, long maxBlockCount, float priority, long minAllocationAlignment, long pMemoryAllocateNext) {
        this.memoryTypeIndex(memoryTypeIndex);
        this.flags(flags);
        this.blockSize(blockSize);
        this.minBlockCount(minBlockCount);
        this.maxBlockCount(maxBlockCount);
        this.priority(priority);
        this.minAllocationAlignment(minAllocationAlignment);
        this.pMemoryAllocateNext(pMemoryAllocateNext);
        return this;
    }

    public VmaPoolCreateInfo set(VmaPoolCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VmaPoolCreateInfo malloc() {
        return (VmaPoolCreateInfo)VmaPoolCreateInfo.wrap(VmaPoolCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VmaPoolCreateInfo calloc() {
        return (VmaPoolCreateInfo)VmaPoolCreateInfo.wrap(VmaPoolCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VmaPoolCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VmaPoolCreateInfo)VmaPoolCreateInfo.wrap(VmaPoolCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VmaPoolCreateInfo create(long address) {
        return (VmaPoolCreateInfo)VmaPoolCreateInfo.wrap(VmaPoolCreateInfo.class, (long)address);
    }

    @Nullable
    public static VmaPoolCreateInfo createSafe(long address) {
        return address == 0L ? null : (VmaPoolCreateInfo)VmaPoolCreateInfo.wrap(VmaPoolCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VmaPoolCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VmaPoolCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VmaPoolCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaPoolCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VmaPoolCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VmaPoolCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VmaPoolCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VmaPoolCreateInfo mallocStack() {
        return VmaPoolCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaPoolCreateInfo callocStack() {
        return VmaPoolCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaPoolCreateInfo mallocStack(MemoryStack stack) {
        return VmaPoolCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VmaPoolCreateInfo callocStack(MemoryStack stack) {
        return VmaPoolCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaPoolCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaPoolCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaPoolCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaPoolCreateInfo.calloc(capacity, stack);
    }

    public static VmaPoolCreateInfo malloc(MemoryStack stack) {
        return (VmaPoolCreateInfo)VmaPoolCreateInfo.wrap(VmaPoolCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaPoolCreateInfo calloc(MemoryStack stack) {
        return (VmaPoolCreateInfo)VmaPoolCreateInfo.wrap(VmaPoolCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaPoolCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaPoolCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nmemoryTypeIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYTYPEINDEX);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long nblockSize(long struct) {
        return UNSAFE.getLong(null, struct + (long)BLOCKSIZE);
    }

    public static long nminBlockCount(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MINBLOCKCOUNT));
    }

    public static long nmaxBlockCount(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MAXBLOCKCOUNT));
    }

    public static float npriority(long struct) {
        return UNSAFE.getFloat(null, struct + (long)PRIORITY);
    }

    public static long nminAllocationAlignment(long struct) {
        return UNSAFE.getLong(null, struct + (long)MINALLOCATIONALIGNMENT);
    }

    public static long npMemoryAllocateNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PMEMORYALLOCATENEXT));
    }

    public static void nmemoryTypeIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MEMORYTYPEINDEX, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nblockSize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BLOCKSIZE, value);
    }

    public static void nminBlockCount(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MINBLOCKCOUNT), (long)value);
    }

    public static void nmaxBlockCount(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MAXBLOCKCOUNT), (long)value);
    }

    public static void npriority(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)PRIORITY, value);
    }

    public static void nminAllocationAlignment(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MINALLOCATIONALIGNMENT, value);
    }

    public static void npMemoryAllocateNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PMEMORYALLOCATENEXT), (long)value);
    }

    static {
        Struct.Layout layout = VmaPoolCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VmaPoolCreateInfo.__member((int)4), VmaPoolCreateInfo.__member((int)4), VmaPoolCreateInfo.__member((int)8), VmaPoolCreateInfo.__member((int)POINTER_SIZE), VmaPoolCreateInfo.__member((int)POINTER_SIZE), VmaPoolCreateInfo.__member((int)4), VmaPoolCreateInfo.__member((int)8), VmaPoolCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MEMORYTYPEINDEX = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
        BLOCKSIZE = layout.offsetof(2);
        MINBLOCKCOUNT = layout.offsetof(3);
        MAXBLOCKCOUNT = layout.offsetof(4);
        PRIORITY = layout.offsetof(5);
        MINALLOCATIONALIGNMENT = layout.offsetof(6);
        PMEMORYALLOCATENEXT = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VmaPoolCreateInfo, Buffer>
    implements NativeResource {
        private static final VmaPoolCreateInfo ELEMENT_FACTORY = VmaPoolCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VmaPoolCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int memoryTypeIndex() {
            return VmaPoolCreateInfo.nmemoryTypeIndex(this.address());
        }

        @NativeType(value="VmaPoolCreateFlags")
        public int flags() {
            return VmaPoolCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long blockSize() {
            return VmaPoolCreateInfo.nblockSize(this.address());
        }

        @NativeType(value="size_t")
        public long minBlockCount() {
            return VmaPoolCreateInfo.nminBlockCount(this.address());
        }

        @NativeType(value="size_t")
        public long maxBlockCount() {
            return VmaPoolCreateInfo.nmaxBlockCount(this.address());
        }

        public float priority() {
            return VmaPoolCreateInfo.npriority(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long minAllocationAlignment() {
            return VmaPoolCreateInfo.nminAllocationAlignment(this.address());
        }

        @NativeType(value="void *")
        public long pMemoryAllocateNext() {
            return VmaPoolCreateInfo.npMemoryAllocateNext(this.address());
        }

        public Buffer memoryTypeIndex(@NativeType(value="uint32_t") int value) {
            VmaPoolCreateInfo.nmemoryTypeIndex(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VmaPoolCreateFlags") int value) {
            VmaPoolCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer blockSize(@NativeType(value="VkDeviceSize") long value) {
            VmaPoolCreateInfo.nblockSize(this.address(), value);
            return this;
        }

        public Buffer minBlockCount(@NativeType(value="size_t") long value) {
            VmaPoolCreateInfo.nminBlockCount(this.address(), value);
            return this;
        }

        public Buffer maxBlockCount(@NativeType(value="size_t") long value) {
            VmaPoolCreateInfo.nmaxBlockCount(this.address(), value);
            return this;
        }

        public Buffer priority(float value) {
            VmaPoolCreateInfo.npriority(this.address(), value);
            return this;
        }

        public Buffer minAllocationAlignment(@NativeType(value="VkDeviceSize") long value) {
            VmaPoolCreateInfo.nminAllocationAlignment(this.address(), value);
            return this;
        }

        public Buffer pMemoryAllocateNext(@NativeType(value="void *") long value) {
            VmaPoolCreateInfo.npMemoryAllocateNext(this.address(), value);
            return this;
        }

        public Buffer pMemoryAllocateNext(VkDedicatedAllocationMemoryAllocateInfoNV value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }

        public Buffer pMemoryAllocateNext(VkExportMemoryAllocateInfo value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }

        public Buffer pMemoryAllocateNext(VkExportMemoryAllocateInfoKHR value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }

        public Buffer pMemoryAllocateNext(VkExportMemoryAllocateInfoNV value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }

        public Buffer pMemoryAllocateNext(VkExportMemoryWin32HandleInfoKHR value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }

        public Buffer pMemoryAllocateNext(VkExportMemoryWin32HandleInfoNV value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }

        public Buffer pMemoryAllocateNext(VkImportMemoryFdInfoKHR value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }

        public Buffer pMemoryAllocateNext(VkImportMemoryHostPointerInfoEXT value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }

        public Buffer pMemoryAllocateNext(VkImportMemoryWin32HandleInfoKHR value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }

        public Buffer pMemoryAllocateNext(VkImportMemoryWin32HandleInfoNV value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }

        public Buffer pMemoryAllocateNext(VkMemoryAllocateFlagsInfo value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }

        public Buffer pMemoryAllocateNext(VkMemoryAllocateFlagsInfoKHR value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }

        public Buffer pMemoryAllocateNext(VkMemoryDedicatedAllocateInfo value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }

        public Buffer pMemoryAllocateNext(VkMemoryDedicatedAllocateInfoKHR value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }

        public Buffer pMemoryAllocateNext(VkMemoryOpaqueCaptureAddressAllocateInfo value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }

        public Buffer pMemoryAllocateNext(VkMemoryOpaqueCaptureAddressAllocateInfoKHR value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }

        public Buffer pMemoryAllocateNext(VkMemoryPriorityAllocateInfoEXT value) {
            return this.pMemoryAllocateNext(value.pNext(this.pMemoryAllocateNext()).address());
        }
    }
}

