/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaVirtualAllocationCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int ALIGNMENT;
    public static final int FLAGS;
    public static final int PUSERDATA;

    public VmaVirtualAllocationCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaVirtualAllocationCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VmaVirtualAllocationCreateInfo.nsize(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long alignment() {
        return VmaVirtualAllocationCreateInfo.nalignment(this.address());
    }

    @NativeType(value="VmaVirtualAllocationCreateFlags")
    public int flags() {
        return VmaVirtualAllocationCreateInfo.nflags(this.address());
    }

    @NativeType(value="void *")
    public long pUserData() {
        return VmaVirtualAllocationCreateInfo.npUserData(this.address());
    }

    public VmaVirtualAllocationCreateInfo size(@NativeType(value="VkDeviceSize") long value) {
        VmaVirtualAllocationCreateInfo.nsize(this.address(), value);
        return this;
    }

    public VmaVirtualAllocationCreateInfo alignment(@NativeType(value="VkDeviceSize") long value) {
        VmaVirtualAllocationCreateInfo.nalignment(this.address(), value);
        return this;
    }

    public VmaVirtualAllocationCreateInfo flags(@NativeType(value="VmaVirtualAllocationCreateFlags") int value) {
        VmaVirtualAllocationCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VmaVirtualAllocationCreateInfo pUserData(@NativeType(value="void *") long value) {
        VmaVirtualAllocationCreateInfo.npUserData(this.address(), value);
        return this;
    }

    public VmaVirtualAllocationCreateInfo set(long size, long alignment, int flags, long pUserData) {
        this.size(size);
        this.alignment(alignment);
        this.flags(flags);
        this.pUserData(pUserData);
        return this;
    }

    public VmaVirtualAllocationCreateInfo set(VmaVirtualAllocationCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VmaVirtualAllocationCreateInfo malloc() {
        return (VmaVirtualAllocationCreateInfo)VmaVirtualAllocationCreateInfo.wrap(VmaVirtualAllocationCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VmaVirtualAllocationCreateInfo calloc() {
        return (VmaVirtualAllocationCreateInfo)VmaVirtualAllocationCreateInfo.wrap(VmaVirtualAllocationCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VmaVirtualAllocationCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VmaVirtualAllocationCreateInfo)VmaVirtualAllocationCreateInfo.wrap(VmaVirtualAllocationCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VmaVirtualAllocationCreateInfo create(long address) {
        return (VmaVirtualAllocationCreateInfo)VmaVirtualAllocationCreateInfo.wrap(VmaVirtualAllocationCreateInfo.class, (long)address);
    }

    @Nullable
    public static VmaVirtualAllocationCreateInfo createSafe(long address) {
        return address == 0L ? null : (VmaVirtualAllocationCreateInfo)VmaVirtualAllocationCreateInfo.wrap(VmaVirtualAllocationCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VmaVirtualAllocationCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VmaVirtualAllocationCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VmaVirtualAllocationCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaVirtualAllocationCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VmaVirtualAllocationCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VmaVirtualAllocationCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VmaVirtualAllocationCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VmaVirtualAllocationCreateInfo malloc(MemoryStack stack) {
        return (VmaVirtualAllocationCreateInfo)VmaVirtualAllocationCreateInfo.wrap(VmaVirtualAllocationCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaVirtualAllocationCreateInfo calloc(MemoryStack stack) {
        return (VmaVirtualAllocationCreateInfo)VmaVirtualAllocationCreateInfo.wrap(VmaVirtualAllocationCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaVirtualAllocationCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaVirtualAllocationCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static long nalignment(long struct) {
        return UNSAFE.getLong(null, struct + (long)ALIGNMENT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PUSERDATA));
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    public static void nalignment(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ALIGNMENT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npUserData(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PUSERDATA), (long)value);
    }

    static {
        Struct.Layout layout = VmaVirtualAllocationCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VmaVirtualAllocationCreateInfo.__member((int)8), VmaVirtualAllocationCreateInfo.__member((int)8), VmaVirtualAllocationCreateInfo.__member((int)4), VmaVirtualAllocationCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        ALIGNMENT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PUSERDATA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VmaVirtualAllocationCreateInfo, Buffer>
    implements NativeResource {
        private static final VmaVirtualAllocationCreateInfo ELEMENT_FACTORY = VmaVirtualAllocationCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VmaVirtualAllocationCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VmaVirtualAllocationCreateInfo.nsize(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long alignment() {
            return VmaVirtualAllocationCreateInfo.nalignment(this.address());
        }

        @NativeType(value="VmaVirtualAllocationCreateFlags")
        public int flags() {
            return VmaVirtualAllocationCreateInfo.nflags(this.address());
        }

        @NativeType(value="void *")
        public long pUserData() {
            return VmaVirtualAllocationCreateInfo.npUserData(this.address());
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VmaVirtualAllocationCreateInfo.nsize(this.address(), value);
            return this;
        }

        public Buffer alignment(@NativeType(value="VkDeviceSize") long value) {
            VmaVirtualAllocationCreateInfo.nalignment(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VmaVirtualAllocationCreateFlags") int value) {
            VmaVirtualAllocationCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pUserData(@NativeType(value="void *") long value) {
            VmaVirtualAllocationCreateInfo.npUserData(this.address(), value);
            return this;
        }
    }
}

