/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="union nk_handle")
public class NkHandle
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PTR;
    public static final int ID;

    public NkHandle(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkHandle.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long ptr() {
        return NkHandle.nptr(this.address());
    }

    public int id() {
        return NkHandle.nid(this.address());
    }

    public NkHandle ptr(@NativeType(value="void *") long value) {
        NkHandle.nptr(this.address(), value);
        return this;
    }

    public NkHandle id(int value) {
        NkHandle.nid(this.address(), value);
        return this;
    }

    public NkHandle set(NkHandle src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkHandle malloc() {
        return (NkHandle)NkHandle.wrap(NkHandle.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkHandle calloc() {
        return (NkHandle)NkHandle.wrap(NkHandle.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkHandle create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkHandle)NkHandle.wrap(NkHandle.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkHandle create(long address) {
        return (NkHandle)NkHandle.wrap(NkHandle.class, (long)address);
    }

    @Nullable
    public static NkHandle createSafe(long address) {
        return address == 0L ? null : (NkHandle)NkHandle.wrap(NkHandle.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkHandle.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkHandle.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkHandle.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkHandle.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkHandle.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkHandle.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkHandle.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static NkHandle mallocStack() {
        return NkHandle.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkHandle callocStack() {
        return NkHandle.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkHandle mallocStack(MemoryStack stack) {
        return NkHandle.malloc(stack);
    }

    @Deprecated
    public static NkHandle callocStack(MemoryStack stack) {
        return NkHandle.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkHandle.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkHandle.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkHandle.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkHandle.calloc(capacity, stack);
    }

    public static NkHandle malloc(MemoryStack stack) {
        return (NkHandle)NkHandle.wrap(NkHandle.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkHandle calloc(MemoryStack stack) {
        return (NkHandle)NkHandle.wrap(NkHandle.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)NkHandle.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)NkHandle.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nptr(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PTR));
    }

    public static int nid(long struct) {
        return UNSAFE.getInt(null, struct + (long)ID);
    }

    public static void nptr(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PTR), (long)value);
    }

    public static void nid(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ID, value);
    }

    static {
        Struct.Layout layout = NkHandle.__union((Struct.Member[])new Struct.Member[]{NkHandle.__member((int)POINTER_SIZE), NkHandle.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PTR = layout.offsetof(0);
        ID = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkHandle, Buffer>
    implements NativeResource {
        private static final NkHandle ELEMENT_FACTORY = NkHandle.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkHandle getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long ptr() {
            return NkHandle.nptr(this.address());
        }

        public int id() {
            return NkHandle.nid(this.address());
        }

        public Buffer ptr(@NativeType(value="void *") long value) {
            NkHandle.nptr(this.address(), value);
            return this;
        }

        public Buffer id(int value) {
            NkHandle.nid(this.address(), value);
            return this;
        }
    }
}

