/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBaseInStructure
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrBaseInStructure(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrBaseInStructure.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBaseInStructure.ntype(this.address());
    }

    @NativeType(value="XrBaseInStructure const *")
    public XrBaseInStructure next() {
        return XrBaseInStructure.nnext(this.address());
    }

    public XrBaseInStructure type(@NativeType(value="XrStructureType") int value) {
        XrBaseInStructure.ntype(this.address(), value);
        return this;
    }

    public XrBaseInStructure next(@NativeType(value="XrBaseInStructure const *") XrBaseInStructure value) {
        XrBaseInStructure.nnext(this.address(), value);
        return this;
    }

    public XrBaseInStructure set(int type, XrBaseInStructure next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrBaseInStructure set(XrBaseInStructure src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrBaseInStructure malloc() {
        return (XrBaseInStructure)XrBaseInStructure.wrap(XrBaseInStructure.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrBaseInStructure calloc() {
        return (XrBaseInStructure)XrBaseInStructure.wrap(XrBaseInStructure.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrBaseInStructure create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrBaseInStructure)XrBaseInStructure.wrap(XrBaseInStructure.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrBaseInStructure create(long address) {
        return (XrBaseInStructure)XrBaseInStructure.wrap(XrBaseInStructure.class, (long)address);
    }

    @Nullable
    public static XrBaseInStructure createSafe(long address) {
        return address == 0L ? null : (XrBaseInStructure)XrBaseInStructure.wrap(XrBaseInStructure.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrBaseInStructure.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrBaseInStructure.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrBaseInStructure.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBaseInStructure.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrBaseInStructure.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrBaseInStructure.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrBaseInStructure.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrBaseInStructure malloc(MemoryStack stack) {
        return (XrBaseInStructure)XrBaseInStructure.wrap(XrBaseInStructure.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrBaseInStructure calloc(MemoryStack stack) {
        return (XrBaseInStructure)XrBaseInStructure.wrap(XrBaseInStructure.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrBaseInStructure.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrBaseInStructure.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static XrBaseInStructure nnext(long struct) {
        return XrBaseInStructure.create(MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, XrBaseInStructure value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    static {
        Struct.Layout layout = XrBaseInStructure.__struct((Struct.Member[])new Struct.Member[]{XrBaseInStructure.__member((int)4), XrBaseInStructure.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrBaseInStructure, Buffer>
    implements NativeResource {
        private static final XrBaseInStructure ELEMENT_FACTORY = XrBaseInStructure.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrBaseInStructure getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBaseInStructure.ntype(this.address());
        }

        @NativeType(value="XrBaseInStructure const *")
        public XrBaseInStructure next() {
            return XrBaseInStructure.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBaseInStructure.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="XrBaseInStructure const *") XrBaseInStructure value) {
            XrBaseInStructure.nnext(this.address(), value);
            return this;
        }
    }
}

