/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.FloatingTextField;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class TextTool
extends CreationTool {
    private FloatingTextField fTextField;
    private TextHolder fTypingTarget;

    public TextTool(DrawingView drawingView, Figure figure) {
        super(drawingView, figure);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        TextHolder textHolder = null;
        Figure figure = this.drawing().findFigureInside(n, n2);
        if (figure instanceof TextHolder && !(textHolder = (TextHolder)((Object)figure)).acceptsTyping()) {
            textHolder = null;
        }
        if (textHolder != null) {
            this.beginEdit(textHolder);
            return;
        }
        if (this.fTypingTarget != null) {
            this.editor().toolDone();
            this.endEdit();
        } else {
            super.mouseDown(mouseEvent, n, n2);
            textHolder = (TextHolder)((Object)this.createdFigure());
            this.beginEdit(textHolder);
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
    }

    public void deactivate() {
        super.deactivate();
        this.endEdit();
    }

    public void activate() {
        super.activate();
        this.view().clearSelection();
    }

    protected void beginEdit(TextHolder textHolder) {
        if (this.fTextField == null) {
            this.fTextField = new FloatingTextField();
        }
        if (textHolder != this.fTypingTarget && this.fTypingTarget != null) {
            this.endEdit();
        }
        this.fTextField.createOverlay((Container)((Object)this.view()), textHolder.getFont());
        this.fTextField.setBounds(this.fieldBounds(textHolder), textHolder.getText());
        this.fTypingTarget = textHolder;
    }

    protected void endEdit() {
        if (this.fTypingTarget != null) {
            if (this.fTextField.getText().length() > 0) {
                this.fTypingTarget.setText(this.fTextField.getText());
            } else {
                this.drawing().remove((Figure)((Object)this.fTypingTarget));
            }
            this.fTypingTarget = null;
            this.fTextField.endOverlay();
            this.view().checkDamage();
        }
    }

    private Rectangle fieldBounds(TextHolder textHolder) {
        Rectangle rectangle = textHolder.textDisplayBox();
        int n = textHolder.overlayRows();
        int n2 = textHolder.overlayColumns();
        Dimension dimension = this.fTextField.getPreferredSize(n, n2);
        return new Rectangle(rectangle.x, rectangle.y, dimension.width, dimension.height);
    }
}

