/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.text;

import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class JavaNumberFormatter
extends DefaultFormatter {
    private double scaleFactor = 1.0;
    private boolean allowsNullValue = false;
    private Comparable min;
    private Comparable max;
    private boolean appendsDotZero = true;

    public JavaNumberFormatter() {
    }

    public JavaNumberFormatter(double d, double d2, double d3) {
        this(d, d2, d3, false, true);
    }

    public JavaNumberFormatter(double d, double d2, double d3, boolean bl, boolean bl2) {
        this.setMinimum(Double.valueOf(d));
        this.setMaximum(Double.valueOf(d2));
        this.setScaleFactor(d3);
        this.setAllowsNullValue(bl);
        this.setAppendsDotZero(bl2);
        this.setOverwriteMode(false);
    }

    public void setMinimum(Comparable comparable) {
        if (this.getValueClass() == null && comparable != null) {
            this.setValueClass(comparable.getClass());
        }
        this.min = comparable;
    }

    public Comparable getMinimum() {
        return this.min;
    }

    public void setMaximum(Comparable comparable) {
        if (this.getValueClass() == null && comparable != null) {
            this.setValueClass(comparable.getClass());
        }
        this.max = comparable;
    }

    public Comparable getMaximum() {
        return this.max;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setAllowsNullValue(boolean bl) {
        this.allowsNullValue = bl;
    }

    public boolean getAllowsNullValue() {
        return this.allowsNullValue;
    }

    public void setAppendsDotZero(boolean bl) {
        this.appendsDotZero = bl;
    }

    public boolean getAppendsDotZero() {
        return this.appendsDotZero;
    }

    @Override
    public String valueToString(Object object) throws ParseException {
        if (object == null && this.allowsNullValue) {
            return "";
        }
        if (object instanceof Double) {
            double d = (Double)object;
            String string = Double.toString(d *= this.scaleFactor);
            if (!this.appendsDotZero && string.endsWith(".0")) {
                string = string.substring(0, string.length() - 2);
            }
            return string;
        }
        if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            f = (float)((double)f * this.scaleFactor);
            String string = Float.toString(f);
            if (this.appendsDotZero && string.endsWith(".0")) {
                string = string.substring(0, string.length() - 2);
            }
            return string;
        }
        if (object instanceof Long) {
            long l = (Long)object;
            l = (long)((double)l * this.scaleFactor);
            return Long.toString(l);
        }
        if (object instanceof Integer) {
            int n = (Integer)object;
            n = (int)((double)n * this.scaleFactor);
            return Integer.toString(n);
        }
        if (object instanceof Byte) {
            byte by = (Byte)object;
            by = (byte)((double)by * this.scaleFactor);
            return Byte.toString(by);
        }
        if (object instanceof Short) {
            short s = (Short)object;
            s = (short)((double)s * this.scaleFactor);
            return Short.toString(s);
        }
        throw new ParseException("Value is of unsupported class " + object, 0);
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        Number number;
        if ((string == null || string.length() == 0) && this.getAllowsNullValue()) {
            return null;
        }
        Class<?> clazz = this.getValueClass();
        if (clazz != null) {
            try {
                if (clazz == Integer.class) {
                    int n = Integer.parseInt(string);
                    n = (int)((double)n / this.scaleFactor);
                    number = new Integer(n);
                }
                if (clazz == Long.class) {
                    long l = Long.parseLong(string);
                    l = (long)((double)l / this.scaleFactor);
                    number = new Long(l);
                }
                if (clazz == Float.class) {
                    float f = Float.parseFloat(string);
                    f = (float)((double)f / this.scaleFactor);
                    number = new Float(f);
                }
                if (clazz == Double.class) {
                    double d = Double.parseDouble(string);
                    number = new Double(d /= this.scaleFactor);
                }
                if (clazz == Byte.class) {
                    byte by = Byte.parseByte(string);
                    by = (byte)((double)by / this.scaleFactor);
                    number = new Byte(by);
                }
                if (clazz == Short.class) {
                    short s = Short.parseShort(string);
                    s = (short)((double)s / this.scaleFactor);
                    number = new Short(s);
                }
                throw new ParseException("Unsupported value class " + clazz, 0);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(numberFormatException.getMessage(), 0);
            }
        } else {
            throw new ParseException("Unsupported value class " + clazz, 0);
        }
        try {
            if (!this.isValidValue(number, true)) {
                throw new ParseException("Value not within min/max range", 0);
            }
        }
        catch (ClassCastException classCastException) {
            throw new ParseException("Class cast exception comparing values: " + classCastException, 0);
        }
        return number;
    }

    boolean isValidValue(Object object, boolean bl) {
        Comparable comparable = this.getMinimum();
        try {
            if (comparable != null && comparable.compareTo(object) > 0) {
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            if (bl) {
                throw classCastException;
            }
            return false;
        }
        Comparable comparable2 = this.getMaximum();
        try {
            if (comparable2 != null && comparable2.compareTo(object) < 0) {
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            if (bl) {
                throw classCastException;
            }
            return false;
        }
        return true;
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory(double d, double d2, double d3) {
        return JavaNumberFormatter.createFormatterFactory(d, d2, d3, false, false);
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory(double d, double d2, double d3, boolean bl, boolean bl2) {
        return new DefaultFormatterFactory(new JavaNumberFormatter(d, d2, d3, bl, bl2));
    }
}

