/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.util.LocalUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DTDEntityResolver
implements EntityResolver {
    private static final String[][] MAPPINGS = new String[][]{{"-//GetAhead Limited//DTD Direct Web Remoting 0.4//EN", "/dwr10.dtd"}, {"-//GetAhead Limited//DTD Direct Web Remoting 1.0//EN", "/dwr10.dtd"}, {"-//GetAhead Limited//DTD Direct Web Remoting 2.0//EN", "/dwr20.dtd"}, {"-//GetAhead Limited//DTD Direct Web Remoting 3.0//EN", "/dwr30.dtd"}};
    private static final Log log = LogFactory.getLog(DTDEntityResolver.class);

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        for (int i = 0; i < MAPPINGS.length; ++i) {
            if (!publicId.equals(MAPPINGS[i][0])) continue;
            if (i != MAPPINGS.length - 1) {
                String doctype = "<!DOCTYPE dwr PUBLIC \"" + MAPPINGS[MAPPINGS.length - 1][0] + "\" \"http://getahead.org/dwr/" + MAPPINGS[MAPPINGS.length - 1][1] + "\">";
                log.warn((Object)("Deprecated public id in dwr.xml. Use: " + doctype));
            }
            String dtdname = "/org/directwebremoting" + MAPPINGS[i][1];
            InputStream raw = LocalUtil.getInternalResourceAsStream(dtdname);
            return new InputSource(raw);
        }
        throw new SAXException("Failed to resolve: publicId=" + publicId + " systemId=" + systemId);
    }
}

