/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.item;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.rest.core.item.EnrichedGroupItemDTO;
import org.openhab.core.io.rest.core.item.EnrichedItemDTO;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.dto.ItemDTO;
import org.openhab.core.items.dto.ItemDTOMapper;
import org.openhab.core.library.items.DateTimeItem;
import org.openhab.core.library.items.NumberItem;
import org.openhab.core.library.types.DateTimeType;
import org.openhab.core.transform.TransformationException;
import org.openhab.core.transform.TransformationHelper;
import org.openhab.core.transform.TransformationService;
import org.openhab.core.types.State;
import org.openhab.core.types.StateDescription;
import org.openhab.core.types.StateDescriptionFragmentBuilder;
import org.openhab.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class EnrichedItemDTOMapper {
    private static final Pattern EXTRACT_TRANSFORM_FUNCTION_PATTERN = Pattern.compile("(.*?)\\((.*)\\):(.*)");
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichedItemDTOMapper.class);

    public static EnrichedItemDTO map(Item item, boolean drillDown, @Nullable Predicate<Item> itemFilter, @Nullable UriBuilder uriBuilder, @Nullable Locale locale, @Nullable ZoneId zoneId) {
        ItemDTO itemDTO = ItemDTOMapper.map((Item)item);
        return EnrichedItemDTOMapper.map(item, itemDTO, drillDown, itemFilter, uriBuilder, locale, zoneId, new ArrayList<Item>());
    }

    private static EnrichedItemDTO mapRecursive(Item item, @Nullable Predicate<Item> itemFilter, @Nullable UriBuilder uriBuilder, @Nullable Locale locale, @Nullable ZoneId zoneId, List<Item> parents) {
        ItemDTO itemDTO = ItemDTOMapper.map((Item)item);
        return EnrichedItemDTOMapper.map(item, itemDTO, true, itemFilter, uriBuilder, locale, zoneId, parents);
    }

    /*
     * Unable to fully structure code
     */
    private static EnrichedItemDTO map(Item item, ItemDTO itemDTO, boolean drillDown, @Nullable Predicate<Item> itemFilter, @Nullable UriBuilder uriBuilder, @Nullable Locale locale, @Nullable ZoneId zoneId, List<Item> parents) {
        if (item instanceof GroupItem) {
            parents.add(item);
        }
        if (!((var10_8 = item) instanceof DateTimeItem)) ** GOTO lbl-1000
        var9_9 = (DateTimeItem)var10_8;
        (DateTimeItem)var10_8;
        if (zoneId != null) {
            dateTime = (DateTimeType)dateTimeItem.getStateAs(DateTimeType.class);
            state = dateTime == null ? item.getState().toFullString() : dateTime.toFullString(zoneId);
        } else lbl-1000:
        // 2 sources

        {
            state = item.getState().toFullString();
        }
        transformedState = EnrichedItemDTOMapper.considerTransformation(item, locale);
        if (state.equals(transformedState)) {
            transformedState = null;
        }
        stateDescription = EnrichedItemDTOMapper.considerTransformation(item.getStateDescription(locale));
        link = uriBuilder != null ? uriBuilder.build(new Object[]{itemDTO.name}).toASCIIString() : null;
        unitSymbol = null;
        var17_15 = item;
        if (var17_15 instanceof NumberItem) {
            var16_16 = (NumberItem)var17_15;
            (NumberItem)var17_15;
            unitSymbol = numberItem.getUnitSymbol();
        }
        if ((var19_17 = item) instanceof GroupItem) {
            var18_18 = (GroupItem)var19_17;
            (GroupItem)var19_17;
            var21_19 = groupItem.getBaseItem();
            if (var21_19 instanceof NumberItem) {
                var20_20 = (NumberItem)var21_19;
                (NumberItem)var21_19;
                unitSymbol = baseNumberItem.getUnitSymbol();
            }
            if (drillDown) {
                members = new LinkedHashSet<EnrichedItemDTO>();
                for (Item member : groupItem.getMembers()) {
                    if (parents.contains(member)) {
                        EnrichedItemDTOMapper.LOGGER.error("Recursive group membership found: {} is a member of {}, but it is also one of its ancestors.", (Object)member.getName(), (Object)groupItem.getName());
                        continue;
                    }
                    if (itemFilter != null && !itemFilter.test(member)) continue;
                    members.add(EnrichedItemDTOMapper.mapRecursive(member, itemFilter, uriBuilder, locale, zoneId, new ArrayList<Item>(parents)));
                }
                memberDTOs = members.toArray(new EnrichedItemDTO[0]);
            } else {
                memberDTOs = new EnrichedItemDTO[]{};
            }
            enrichedItemDTO = new EnrichedGroupItemDTO(itemDTO, memberDTOs, link, state, transformedState, stateDescription, unitSymbol);
        } else {
            enrichedItemDTO = new EnrichedItemDTO(itemDTO, link, state, transformedState, stateDescription, item.getCommandDescription(locale), unitSymbol);
        }
        return enrichedItemDTO;
    }

    private static @Nullable StateDescription considerTransformation(@Nullable StateDescription stateDescription) {
        String pattern;
        if (stateDescription != null && (pattern = stateDescription.getPattern()) != null) {
            return TransformationHelper.isTransform((String)pattern) ? StateDescriptionFragmentBuilder.create((StateDescription)stateDescription).withPattern(pattern).build().toStateDescription() : stateDescription;
        }
        return stateDescription;
    }

    private static @Nullable String considerTransformation(Item item, @Nullable Locale locale) {
        Matcher matcher;
        String pattern;
        StateDescription stateDescription = item.getStateDescription(locale);
        if (stateDescription != null && (pattern = stateDescription.getPattern()) != null && (matcher = EXTRACT_TRANSFORM_FUNCTION_PATTERN.matcher(pattern)).find()) {
            State state = item.getState();
            try {
                String type = matcher.group(1);
                String function = matcher.group(2);
                String value = matcher.group(3);
                TransformationService transformation = TransformationHelper.getTransformationService((String)type);
                if (transformation != null) {
                    String format = state instanceof UnDefType ? "%s" : value;
                    try {
                        return transformation.transform(function, state.format(format));
                    }
                    catch (IllegalArgumentException e) {
                        throw new TransformationException("Cannot format state '" + String.valueOf(state) + "' to format '" + format + "'", (Throwable)e);
                    }
                    catch (RuntimeException e) {
                        throw new TransformationException("Transformation service of type '" + type + "' threw an exception: " + e.getMessage(), (Throwable)e);
                    }
                }
                throw new TransformationException("Transformation service of type '" + type + "' is not available.");
            }
            catch (TransformationException e) {
                LOGGER.warn("Failed transforming the state '{}' on item '{}' with pattern '{}': {}", new Object[]{state, item.getName(), pattern, e.getMessage()});
            }
        }
        return null;
    }
}

